/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlUtils {
    private static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";

    private XmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaFactory newXmlSchemaFactory() {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (SchemaFactoryConfigurationError e) {
            Logging.debug(e);
            Thread currentThread = Thread.currentThread();
            ClassLoader old = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(null);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                return schemaFactory;
            }
            finally {
                currentThread.setContextClassLoader(old);
            }
        }
    }

    public static DocumentBuilder newSafeDOMBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        return builderFactory.newDocumentBuilder();
    }

    public static Document parseSafeDOM(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Logging.debug("Starting DOM parsing of {0}", is);
        Document result = XmlUtils.newSafeDOMBuilder().parse(is);
        Logging.debug(stopwatch.toString("DOM parsing"));
        return result;
    }

    public static SAXParser newSafeSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parserFactory.setFeature(FEATURE_DISALLOW_DOCTYPE_DECL, true);
        parserFactory.setNamespaceAware(true);
        return parserFactory.newSAXParser();
    }

    public static void parseSafeSAX(InputSource is, DefaultHandler dh) throws ParserConfigurationException, SAXException, IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Logging.debug("Starting SAX parsing of {0} using {1}", is, dh);
        XmlUtils.newSafeSAXParser().parse(is, dh);
        Logging.debug(stopwatch.toString("SAX parsing"));
    }

    public static XMLInputFactory newSafeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory;
    }

    public static TransformerFactory newSafeTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }

    public static Validator newSafeValidator(Schema schema) {
        Validator validator = schema.newValidator();
        try {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            Logging.trace(e);
        }
        return validator;
    }

    public static Element getFirstChildElement(Node parent) {
        NodeList children = parent.getChildNodes();
        return IntStream.range(0, children.getLength()).mapToObj(children::item).filter(child -> child instanceof Element).findFirst().orElse(null);
    }
}

