/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.peer.TurbineRolePermissionPeerMapper;
import org.apache.fulcrum.security.torque.peer.TurbineUserGroupRoleModelPeerMapper;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class DefaultAbstractTurbineRole
extends TorqueAbstractTurbineTurbineSecurityEntity
implements TurbineRole {
    private static final long serialVersionUID = -1782236723198646728L;
    private Set<Permission> permissionSet = null;

    protected <T extends TurbineRolePermissionPeerMapper> List<T> getTurbineRolePermissionsJoinTurbinePermission(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
        return TurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria, con);
    }

    protected <T extends TurbineUserGroupRoleModelPeerMapper> List<T> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria, Connection con) throws TorqueException, DataBackendException {
        criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
        return TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, con);
    }

    public void addPermission(Permission permission) {
        this.getPermissions().add((SecurityEntity)permission);
    }

    public PermissionSet getPermissions() {
        if (this.permissionSet == null) {
            this.permissionSet = new PermissionSet();
        } else if (!(this.permissionSet instanceof PermissionSet)) {
            this.permissionSet = new PermissionSet(this.permissionSet);
        }
        return (PermissionSet)this.permissionSet;
    }

    public <T extends Permission> Set<T> getPermissionsAsSet() {
        return this.permissionSet;
    }

    public void removePermission(Permission permission) {
        this.getPermissions().remove((Object)permission);
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet != null ? permissionSet : new PermissionSet();
    }

    public <T extends Permission> void setPermissionsAsSet(Set<T> permissions) {
        this.setPermissions(new PermissionSet(permissions));
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.permissionSet = new PermissionSet();
        try {
            List rolepermissions = this.getTurbineRolePermissionsJoinTurbinePermission(new Criteria(), con);
            for (TurbineRolePermissionPeerMapper ttrp : rolepermissions) {
                this.permissionSet.add(ttrp.getTurbinePermission());
            }
            if (!lazy.booleanValue()) {
                HashSet<TurbineUserGroupRole> userGroupRoleSet = new HashSet<TurbineUserGroupRole>();
                List ugrs = this.getTurbineUserGroupRolesJoinTurbineGroup(new Criteria(), con);
                for (TurbineUserGroupRoleModelPeerMapper ttugr : ugrs) {
                    TurbineUserGroupRole ugr = new TurbineUserGroupRole();
                    ugr.setRole((Role)this);
                    ugr.setGroup(ttugr.getTurbineGroup());
                    ugr.setUser(ttugr.getTurbineUser(con));
                    userGroupRoleSet.add(ugr);
                }
                this.setUserGroupRoleSet(userGroupRoleSet);
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends TurbineUserGroupRole> Set<T> getUserGroupRoleSet() throws DataBackendException {
        if (super.getUserGroupRoleSet() == null || super.getUserGroupRoleSet().isEmpty()) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                this.retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving group information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        }
        return super.getUserGroupRoleSet();
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.permissionSet != null && !this.permissionSet.isEmpty()) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            TurbineRolePermissionPeer.doDelete(criteria, con);
            for (Permission p : this.permissionSet) {
                TurbineRolePermission rp = new TurbineRolePermission();
                rp.setPermissionId((Integer)p.getId());
                rp.setRoleId(this.getEntityId());
                rp.save(con);
            }
        }
    }

    @Override
    public void delete() throws TorqueException {
        TurbineRolePeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

