/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractGroupManagerTest
extends BaseUnit5Test {
    protected Group group;
    protected GroupManager groupManager;
    protected SecurityService securityService;

    @Test
    public void testGetGroupInstance() throws Exception {
        this.group = this.groupManager.getGroupInstance();
        Assertions.assertNotNull((Object)this.group);
        Assertions.assertTrue((this.group.getName() == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetGroupInstanceString() throws Exception {
        this.group = this.groupManager.getGroupInstance("DOG_CATCHER");
        Assertions.assertEquals((Object)"DOG_CATCHER".toLowerCase(), (Object)this.group.getName());
    }

    @Test
    public void testGetGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("DOG_CATCHER2");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupByName("DOG_CATCHER2");
        Assertions.assertEquals((Object)this.group.getName(), (Object)group2.getName());
    }

    @Test
    public void testGetGroupByName() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupByName("CLEAN_KENNEL");
        Assertions.assertEquals((Object)this.group.getName(), (Object)group2.getName());
        group2 = this.groupManager.getGroupByName("Clean_KeNNel");
        Assertions.assertEquals((Object)this.group.getName(), (Object)group2.getName());
    }

    @Test
    public void testGetGroupById() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_A");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupById(this.group.getId());
        Assertions.assertEquals((Object)this.group.getName(), (Object)group2.getName());
    }

    @Test
    public void testGetAllGroups() throws Exception {
        int size = this.groupManager.getAllGroups().size();
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_J");
        this.groupManager.addGroup(this.group);
        GroupSet groupSet = this.groupManager.getAllGroups();
        Assertions.assertEquals((int)(size + 1), (int)groupSet.size());
    }

    @Test
    public void testRemoveGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_K");
        this.groupManager.addGroup(this.group);
        int size = this.groupManager.getAllGroups().size();
        if (this.group instanceof DynamicGroup) {
            Assertions.assertEquals((int)0, (int)((DynamicGroup)this.group).getUsers().size());
            Assertions.assertEquals((int)0, (int)((DynamicGroup)this.group).getRoles().size());
        }
        this.groupManager.removeGroup(this.group);
        try {
            Group group2 = this.groupManager.getGroupById(this.group.getId());
            Assertions.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        Assertions.assertEquals((int)(size - 1), (int)this.groupManager.getAllGroups().size());
    }

    @Test
    public void testRenameGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_X");
        this.groupManager.addGroup(this.group);
        int size = this.groupManager.getAllGroups().size();
        this.groupManager.renameGroup(this.group, "CLEAN_GROOMING_ROOM");
        Group group2 = this.groupManager.getGroupById(this.group.getId());
        Assertions.assertEquals((Object)"CLEAN_GROOMING_ROOM".toLowerCase(), (Object)group2.getName());
        Assertions.assertEquals((int)size, (int)this.groupManager.getAllGroups().size());
    }

    @Test
    public void testCheckExists() throws Exception {
        this.group = this.groupManager.getGroupInstance("GREET_PEOPLE");
        this.groupManager.addGroup(this.group);
        Assertions.assertTrue((boolean)this.groupManager.checkExists(this.group));
        Group group2 = this.groupManager.getGroupInstance("WALK_DOGS");
        Assertions.assertFalse((boolean)this.groupManager.checkExists(group2));
    }

    @Test
    public void testCheckExistsWithString() throws Exception {
        this.group = this.groupManager.getGroupInstance("GREET_PEOPLE2");
        this.groupManager.addGroup(this.group);
        Assertions.assertTrue((boolean)this.groupManager.checkExists(this.group.getName()));
        Group group2 = this.groupManager.getGroupInstance("WALK_DOGS2");
        Assertions.assertFalse((boolean)this.groupManager.checkExists(group2.getName()));
    }

    @Test
    public void testAddGroupTwiceFails() throws Exception {
        this.group = this.groupManager.getGroupInstance("EATLUNCH");
        this.groupManager.addGroup(this.group);
        Assertions.assertTrue((boolean)this.groupManager.checkExists(this.group.getName()));
        Group group2 = this.groupManager.getGroupInstance("EATLUNCH");
        try {
            this.groupManager.addGroup(group2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testAddGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_RABBIT_HUTCHES");
        Assertions.assertNull((Object)this.group.getId());
        this.groupManager.addGroup(this.group);
        Assertions.assertNotNull((Object)this.group.getId());
        Assertions.assertNotNull((Object)this.groupManager.getGroupById(this.group.getId()));
    }
}

