/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl.extensions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensionDeserializer;
import javax.wsdl.extensions.UnknownExtensionSerializer;
import javax.xml.namespace.QName;

public class ExtensionRegistry
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<Class<?>, Map<QName, ExtensionSerializer>> serializerReg = new HashMap();
    private final Map<Class<?>, Map<QName, ExtensionDeserializer>> deserializerReg = new HashMap();
    private final Map<Class<?>, Map<QName, Class<?>>> extensionTypeReg = new HashMap();
    private ExtensionSerializer defaultSer = null;
    private ExtensionDeserializer defaultDeser = null;
    private final Map<Class<?>, Map<QName, Integer>> extensionAttributeTypeReg = new HashMap();

    public ExtensionRegistry() {
        this.setDefaultSerializer(new UnknownExtensionSerializer());
        this.setDefaultDeserializer(new UnknownExtensionDeserializer());
    }

    public void setDefaultSerializer(ExtensionSerializer defaultSer) {
        this.defaultSer = defaultSer;
    }

    public ExtensionSerializer getDefaultSerializer() {
        return this.defaultSer;
    }

    public void setDefaultDeserializer(ExtensionDeserializer defaultDeser) {
        this.defaultDeser = defaultDeser;
    }

    public ExtensionDeserializer getDefaultDeserializer() {
        return this.defaultDeser;
    }

    public void registerSerializer(Class<?> parentType, QName elementType, ExtensionSerializer es) {
        Map innerSerializerReg = this.serializerReg.computeIfAbsent(parentType, key -> new HashMap());
        innerSerializerReg.put(elementType, es);
    }

    public void registerDeserializer(Class<?> parentType, QName elementType, ExtensionDeserializer ed) {
        Map innerDeserializerReg = this.deserializerReg.computeIfAbsent(parentType, key -> new HashMap());
        innerDeserializerReg.put(elementType, ed);
    }

    public ExtensionSerializer querySerializer(Class<?> parentType, QName elementType) throws WSDLException {
        Map<QName, ExtensionSerializer> innerSerializerReg = this.serializerReg.get(parentType);
        ExtensionSerializer es = null;
        if (innerSerializerReg != null) {
            es = innerSerializerReg.get(elementType);
        }
        if (es == null) {
            es = this.defaultSer;
        }
        if (es == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionSerializer found to serialize a '" + String.valueOf(elementType) + "' element in the context of a '" + parentType.getName() + "'.");
        }
        return es;
    }

    public ExtensionDeserializer queryDeserializer(Class<?> parentType, QName elementType) throws WSDLException {
        Map<QName, ExtensionDeserializer> innerDeserializerReg = this.deserializerReg.get(parentType);
        ExtensionDeserializer ed = null;
        if (innerDeserializerReg != null) {
            ed = innerDeserializerReg.get(elementType);
        }
        if (ed == null) {
            ed = this.defaultDeser;
        }
        if (ed == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionDeserializer found to deserialize a '" + String.valueOf(elementType) + "' element in the context of a '" + parentType.getName() + "'.");
        }
        return ed;
    }

    public Set<QName> getAllowableExtensions(Class<?> parentType) {
        Map<QName, ExtensionDeserializer> innerDeserializerReg = this.deserializerReg.get(parentType);
        return innerDeserializerReg != null ? innerDeserializerReg.keySet() : null;
    }

    public void mapExtensionTypes(Class<?> parentType, QName elementType, Class<?> extensionType) {
        Map innerExtensionTypeReg = this.extensionTypeReg.computeIfAbsent(parentType, key -> new HashMap());
        innerExtensionTypeReg.put(elementType, extensionType);
    }

    public ExtensibilityElement createExtension(Class<?> parentType, QName elementType) throws WSDLException {
        Map<QName, Class<?>> innerExtensionTypeReg = this.extensionTypeReg.get(parentType);
        Class<?> extensionType = null;
        if (innerExtensionTypeReg != null) {
            extensionType = innerExtensionTypeReg.get(elementType);
        }
        if (extensionType == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No Java extensionType found to represent a '" + String.valueOf(elementType) + "' element in the context of a '" + parentType.getName() + "'.");
        }
        if (!ExtensibilityElement.class.isAssignableFrom(extensionType)) {
            throw new WSDLException("CONFIGURATION_ERROR", "The Java extensionType '" + extensionType.getName() + "' does not implement the ExtensibilityElement interface.");
        }
        try {
            ExtensibilityElement ee = (ExtensibilityElement)extensionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (ee.getElementType() == null) {
                ee.setElementType(elementType);
            }
            return ee;
        }
        catch (Exception e) {
            throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating Java extensionType '" + extensionType.getName() + "'.", e);
        }
    }

    public void registerExtensionAttributeType(Class<?> parentType, QName attrName, int attrType) {
        Map innerExtensionAttributeTypeReg = this.extensionAttributeTypeReg.computeIfAbsent(parentType, key -> new HashMap());
        innerExtensionAttributeTypeReg.put(attrName, attrType);
    }

    public int queryExtensionAttributeType(Class<?> parentType, QName attrName) {
        Map<QName, Integer> innerExtensionAttributeTypeReg = this.extensionAttributeTypeReg.get(parentType);
        Integer attrType = null;
        if (innerExtensionAttributeTypeReg != null) {
            attrType = innerExtensionAttributeTypeReg.get(attrName);
        }
        if (attrType != null) {
            return attrType;
        }
        return -1;
    }
}

