/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotatedCallable;
import org.apache.webbeans.portable.AnnotatedParameterImpl;
import org.apache.webbeans.util.GenericsUtil;

public class AnnotatedConstructorImpl<X>
extends AbstractAnnotatedCallable<X>
implements AnnotatedConstructor<X> {
    public AnnotatedConstructorImpl(WebBeansContext webBeansContext, Constructor<X> javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, javaMember.getDeclaringClass(), javaMember, declaringType);
        this.setAnnotations(AnnotatedConstructorImpl.findAnnotations(javaMember));
        this.setAnnotatedParameters(GenericsUtil.resolveParameterTypes(declaringType.getJavaClass(), javaMember), javaMember.getParameterAnnotations());
    }

    public AnnotatedConstructorImpl(WebBeansContext webBeansContext, AnnotatedConstructor<X> annotatedConstructor, AnnotatedType<X> declaringType) {
        super(webBeansContext, annotatedConstructor.getBaseType(), annotatedConstructor.getJavaMember(), declaringType);
        this.getAnnotations().addAll(annotatedConstructor.getAnnotations());
        for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
            this.getParameters().add(new AnnotatedParameterImpl(webBeansContext, annotatedParameter.getBaseType(), this, annotatedParameter.getPosition()));
        }
    }

    private static Annotation[] findAnnotations(Constructor<?> javaMember) {
        if (javaMember.getParameterTypes().length == 0) {
            Class<?> clazz = javaMember.getDeclaringClass();
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation a : javaMember.getDeclaredAnnotations()) {
                annotations.put(a.annotationType(), a);
            }
            for (Class<?> current = clazz.getSuperclass(); current != null && current != Object.class; current = current.getSuperclass()) {
                Constructor<?> parentCons;
                try {
                    parentCons = current.getConstructor(new Class[0]);
                }
                catch (Throwable e) {
                    break;
                }
                for (Annotation a : parentCons.getAnnotations()) {
                    Class<? extends Annotation> annotationType = a.annotationType();
                    if (annotations.containsKey(annotationType) || annotationType.getAnnotation(Inherited.class) == null) continue;
                    annotations.put(annotationType, a);
                }
            }
            return annotations.values().toArray(new Annotation[annotations.size()]);
        }
        return javaMember.getDeclaredAnnotations();
    }

    @Override
    public Constructor<X> getJavaMember() {
        return (Constructor)Constructor.class.cast(this.javaMember);
    }

    @Override
    public String toString() {
        return "Annotated Constructor," + super.toString();
    }
}

