/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.PropertyName;
import io.smallrye.config.common.AbstractConfigSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DefaultValuesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -6386021034957868328L;
    public static final String NAME = "DefaultValuesConfigSource";
    public static final int ORDINAL = Integer.MIN_VALUE;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<PropertyName, String> wildcards = new HashMap<PropertyName, String>();
    private final boolean hasProfiledName;

    public DefaultValuesConfigSource(Map<String, String> properties) {
        this(properties, NAME, Integer.MIN_VALUE);
    }

    public DefaultValuesConfigSource(Map<String, String> properties, String name, int ordinal) {
        super(name, ordinal);
        boolean hasProfiledName = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            String value = entry.getValue();
            if (propertyName.indexOf(42) == -1) {
                this.properties.put(propertyName, value);
            } else {
                this.wildcards.put(new PropertyName(propertyName), value);
            }
            if (hasProfiledName || propertyName.isEmpty() || propertyName.charAt(0) != '%') continue;
            hasProfiledName = true;
        }
        this.hasProfiledName = hasProfiledName;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getValue(String propertyName) {
        if (!this.hasProfiledName && !propertyName.isEmpty() && propertyName.charAt(0) == '%') {
            return null;
        }
        String value = this.properties.get(propertyName);
        if (value == null) {
            value = this.wildcards.get(new PropertyName(propertyName));
        }
        return value;
    }

    void addDefaults(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.addDefault(entry.getKey(), entry.getValue());
        }
    }

    void addDefault(String name, String value) {
        if (name.indexOf(42) == -1) {
            this.properties.putIfAbsent(name, value);
        } else {
            this.wildcards.putIfAbsent(new PropertyName(name), value);
        }
    }
}

