/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BaseConvertDefinitions;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ConvertManagedThreadFactoryDefinitions
extends BaseConvertDefinitions {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection managedThreadFactories = new KeyedCollection();
        KeyedCollection managedThreadFactoriesFromCompManagedBeans = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            if (consumer instanceof CompManagedBean) {
                managedThreadFactoriesFromCompManagedBeans.addAll(consumer.getManagedThreadFactoryMap().values());
                continue;
            }
            managedThreadFactories.addAll(consumer.getManagedThreadFactoryMap().values());
        }
        Map managedThreadFactoriesMap = managedThreadFactories.toMap();
        for (org.apache.openejb.jee.ManagedThreadFactory managedThreadFactory : managedThreadFactoriesFromCompManagedBeans) {
            if (managedThreadFactoriesMap.containsKey(managedThreadFactory.getName().getvalue())) continue;
            managedThreadFactories.add((Object)managedThreadFactory);
        }
        for (org.apache.openejb.jee.ManagedThreadFactory managedThreadFactory : managedThreadFactories) {
            appModule.getResources().add(this.toResource(managedThreadFactory));
        }
        return appModule;
    }

    private Resource toResource(org.apache.openejb.jee.ManagedThreadFactory managedThreadFactory) {
        String name = this.cleanUpName(managedThreadFactory.getName().getvalue());
        Resource def = new Resource(name, ManagedThreadFactory.class.getName());
        def.setJndi(managedThreadFactory.getName().getvalue().replaceFirst("java:", ""));
        String contextName = managedThreadFactory.getContextService().getvalue();
        if ("java:comp/DefaultContextService".equals(contextName)) {
            contextName = "Default Context Service";
        }
        Properties p = def.getProperties();
        ConvertManagedThreadFactoryDefinitions.put(p, "Context", contextName);
        ConvertManagedThreadFactoryDefinitions.put(p, "Priority", managedThreadFactory.getPriority());
        ConvertManagedThreadFactoryDefinitions.put(p, "JndiName", def.getJndi());
        return def;
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, PropertyPlaceHolderHelper.value(String.valueOf(value)));
    }
}

