/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.reparent.Attribute;
import java.util.List;
import java.util.Map;

public class UnboundCall
extends Call {
    private final TemplateName callee;
    private final Expression content;

    public UnboundCall(SourcePosition sourcePosition, String displayName, TemplateName callee, Map<String, Attribute> attributes, List<String> attrBundles, Expression content) {
        super(sourcePosition, displayName, null, attributes, attrBundles);
        this.callee = Preconditions.checkNotNull(callee);
        this.content = Preconditions.checkNotNull(content);
    }

    public TemplateName getCallee() {
        return this.callee;
    }

    public Expression getContent() {
        return this.content;
    }

    @Override
    public Call transformParams(ExhaustiveExpressionVisitor visitor) {
        ImmutableMap.Builder<String, Attribute> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Attribute> param : this.getAttributes().entrySet()) {
            mapBuilder.put(param.getKey(), visitor.visitAttribute(param.getValue()));
        }
        Expression newContent = this.getContent().acceptVisitor(visitor);
        return this.withParamsAndContent(mapBuilder.build(), newContent);
    }

    public UnboundCall withParamsAndContent(Map<String, Attribute> newAttributes, Expression newContent) {
        return Objects.equal(this.getAttributes(), newAttributes) && Objects.equal(this.getContent(), newContent) ? this : new UnboundCall(this.getSourcePosition(), this.getDisplayName(), this.getCallee(), newAttributes, this.getAttrBundles(), newContent);
    }

    @Override
    public final <T> T acceptCallVisitor(CallVisitor<T> visitor) {
        return visitor.visitUnboundCall(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof UnboundCall && this.equals((UnboundCall)that);
    }

    public boolean equals(UnboundCall that) {
        return this.equalsCall(that) && Objects.equal(this.getContent(), that.getContent()) && Objects.equal(this.getCallee(), that.getCallee());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.callHashCode(), this.getContent(), this.callee);
    }
}

