/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.annotations.via.OriginalResourceType;
import org.apache.sling.models.impl.via.ResourceTypeForcingJakartaRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingResourceWrapper;
import org.apache.sling.models.spi.ViaProvider;
import org.osgi.service.component.annotations.Component;

@Component
public class OriginalResourceTypeViaProvider
implements ViaProvider {
    public Class<? extends ViaProviderType> getType() {
        return OriginalResourceType.class;
    }

    public Object getAdaptable(Object original, String value) {
        if (original instanceof SlingJakartaHttpServletRequest) {
            SlingJakartaHttpServletRequest originalRequest = (SlingJakartaHttpServletRequest)original;
            while (originalRequest instanceof ResourceTypeForcingJakartaRequestWrapper) {
                ResourceTypeForcingJakartaRequestWrapper jakartaRequest = (ResourceTypeForcingJakartaRequestWrapper)originalRequest;
                originalRequest = jakartaRequest.getSlingRequest();
            }
            return originalRequest;
        }
        if (original instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest originalRequest = (SlingHttpServletRequest)original;
            while (originalRequest instanceof ResourceTypeForcingRequestWrapper) {
                ResourceTypeForcingRequestWrapper javaxRequest = (ResourceTypeForcingRequestWrapper)originalRequest;
                originalRequest = javaxRequest.getSlingRequest();
            }
            return originalRequest;
        }
        if (original instanceof Resource) {
            Resource originalResource = (Resource)original;
            while (originalResource instanceof ResourceTypeForcingResourceWrapper) {
                ResourceTypeForcingResourceWrapper wrapper = (ResourceTypeForcingResourceWrapper)originalResource;
                originalResource = wrapper.getResource();
            }
            return originalResource;
        }
        return null;
    }
}

