/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public class FeatureNaming<E> {
    private final Map<String, Set<String>> aliases = new HashMap<String, Set<String>>();
    private final Map<String, E> values = new HashMap<String, E>();

    private static CharSequence name(DataStore store) {
        String name;
        if (store != null && (name = store.getDisplayName()) != null) {
            return name;
        }
        return Vocabulary.formatInternational((short)208);
    }

    private static Locale locale(DataStore store) {
        return store != null ? store.getLocale() : null;
    }

    public E get(DataStore store, String name) throws IllegalNameException {
        Object[] params;
        short key;
        E value = this.values.get(name);
        if (value != null) {
            return value;
        }
        Set<String> nc = this.aliases.get(name);
        if (nc == null) {
            key = 17;
            params = new CharSequence[]{FeatureNaming.name(store), name};
        } else if (nc.size() >= 2) {
            key = 15;
            Iterator<String> it = nc.iterator();
            params = new CharSequence[]{FeatureNaming.name(store), it.next(), it.next(), name};
        } else {
            return null;
        }
        throw new IllegalNameException(FeatureNaming.locale(store), key, params);
    }

    public void add(DataStore store, GenericName name, E value) throws IllegalNameException {
        String key = name.toString();
        E previous = this.values.put(key, Objects.requireNonNull(value));
        if (previous != null) {
            Set<String> fullNames = this.aliases.get(key);
            if (fullNames == null || fullNames.contains(key)) {
                if (this.values.put(key, previous) != value) {
                    throw new ConcurrentModificationException(FeatureNaming.name(store).toString());
                }
                throw new IllegalNameException(FeatureNaming.locale(store), 16, FeatureNaming.name(store), key);
            }
            CollectionsExt.addToMultiValuesMap(this.aliases, (Object)key, (Object)key);
        }
        while (name instanceof ScopedName) {
            String alias = (name = ((ScopedName)name).tail()).toString();
            Set fullNames = CollectionsExt.addToMultiValuesMap(this.aliases, (Object)alias, (Object)key);
            if (fullNames.size() > 1) {
                if (fullNames.contains(alias)) continue;
                this.values.remove(alias);
                continue;
            }
            if (this.values.putIfAbsent(alias, value) == null) continue;
            assert (!fullNames.contains(alias)) : alias;
            CollectionsExt.addToMultiValuesMap(this.aliases, (Object)alias, (Object)alias);
        }
    }

    public boolean remove(DataStore store, GenericName name) throws IllegalNameException {
        String key = name.toString();
        if (this.values.remove(key) == null) {
            return false;
        }
        Set remaining = CollectionsExt.removeFromMultiValuesMap(this.aliases, (Object)key, (Object)key);
        if (remaining != null && remaining.size() == 1) {
            String select = (String)remaining.iterator().next();
            assert (!select.equals(key)) : select;
            if (this.values.put(key, this.values.get(select)) != null) {
                throw new ConcurrentModificationException(FeatureNaming.name(store).toString());
            }
        }
        boolean error = false;
        while (name instanceof ScopedName) {
            String alias = (name = ((ScopedName)name).tail()).toString();
            remaining = CollectionsExt.removeFromMultiValuesMap(this.aliases, (Object)alias, (Object)key);
            error |= remaining == null;
            if (remaining == null || remaining.isEmpty()) {
                error |= this.values.remove(alias) == null;
                continue;
            }
            if (remaining.size() != 1) continue;
            String select = (String)remaining.iterator().next();
            assert (!select.equals(key)) : select;
            error |= this.values.putIfAbsent(alias, this.values.get(select)) != null;
        }
        if (error) {
            throw new IllegalNameException(FeatureNaming.locale(store), 10, FeatureNaming.name(store), key);
        }
        return true;
    }
}

