/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.PrimaryKey;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.opengis.util.GenericName;

abstract class FeatureAnalyzer {
    final Analyzer analyzer;
    final TableReference id;
    private Class<?> primaryKeyClass;
    private boolean primaryKeyNullable;
    final Set<String> primaryKey;
    private final Map<String, List<Relation>> foreignerKeys;
    final FeatureTypeBuilder feature;
    private int countLowerCaseStarts;
    boolean hasGeometry;
    boolean hasRaster;

    protected FeatureAnalyzer(Analyzer analyzer, TableReference id) {
        this.analyzer = analyzer;
        this.id = id;
        this.primaryKey = new LinkedHashSet<String>();
        this.foreignerKeys = new HashMap<String, List<Relation>>();
        this.feature = new FeatureTypeBuilder(analyzer.nameFactory, analyzer.database.geomLibrary.library, analyzer.database.listeners.getLocale());
    }

    abstract Relation[] getForeignerKeys(Relation.Direction var1) throws SQLException, DataStoreException;

    final void addForeignerKeys(Relation relation) {
        for (String column : relation.getOwnerColumns()) {
            this.foreignerKeys.computeIfAbsent(column, key -> new ArrayList()).add(relation);
            relation = null;
        }
    }

    abstract Column[] createAttributes() throws Exception;

    final boolean createAttribute(Column column) throws Exception {
        boolean created;
        boolean isPrimaryKey = this.primaryKey.contains(column.name);
        List<Relation> dependencies = this.foreignerKeys.get(column.name);
        this.updateCaseHeuristic(column.label);
        AttributeTypeBuilder<?> attribute = null;
        boolean bl = created = isPrimaryKey || dependencies == null;
        if (created) {
            ValueGetter<?> getter = this.analyzer.setValueGetterOf(column);
            attribute = column.createAttribute(this.feature);
            if (isPrimaryKey) {
                attribute.addRole(AttributeRole.IDENTIFIER_COMPONENT);
                this.primaryKeyNullable |= column.isNullable;
                this.primaryKeyClass = Classes.findCommonClass(this.primaryKeyClass, getter.valueType);
            }
            if (!this.hasGeometry && Geometries.isKnownType(getter.valueType)) {
                this.hasGeometry = true;
                attribute.addRole(AttributeRole.DEFAULT_GEOMETRY);
            }
            if (!this.hasRaster) {
                this.hasRaster = GridCoverage.class.isAssignableFrom(getter.valueType);
            }
        }
        if (dependencies != null) {
            int count = 0;
            for (Relation dependency : dependencies) {
                AssociationRoleBuilder association;
                if (dependency == null || dependency.excluded) continue;
                GenericName typeName = dependency.getName(this.analyzer);
                Table table = this.analyzer.table(dependency, typeName, this.id);
                dependency.setPropertyName(column.getPropertyName(), count++);
                if (table != null) {
                    dependency.setSearchTable(this.analyzer, table, table.primaryKey, Relation.Direction.IMPORT);
                    association = this.feature.addAssociation(table.featureType);
                } else {
                    association = this.feature.addAssociation(typeName);
                }
                association.setName((CharSequence)dependency.getPropertyName());
                if (column.isNullable) {
                    association.setMinimumOccurs(0);
                }
                if (attribute == null) continue;
                attribute.setName(this.analyzer.nameFactory.createGenericName(null, new CharSequence[]{"pk", column.getPropertyName()}));
                column.setPropertyName(attribute);
                attribute = null;
            }
        }
        return created;
    }

    final PrimaryKey createAssociations(Relation[] exportedKeys) throws Exception {
        if (this.primaryKey.size() > 1) {
            if (!this.primaryKeyNullable) {
                this.primaryKeyClass = Numbers.wrapperToPrimitive(this.primaryKeyClass);
            }
            this.primaryKeyClass = Classes.changeArrayDimension(this.primaryKeyClass, (int)1);
        }
        PrimaryKey pk = PrimaryKey.create(this.primaryKeyClass, this.primaryKey);
        int count = 0;
        for (Relation dependency : exportedKeys) {
            AssociationRoleBuilder association;
            if (dependency == null || dependency.excluded) continue;
            GenericName typeName = dependency.getName(this.analyzer);
            Object propertyName = this.toHeuristicLabel(typeName.tip().toString());
            String base = propertyName;
            while (this.feature.isNameUsed((String)propertyName)) {
                propertyName = base + "-" + ++count;
            }
            dependency.setPropertyName((String)propertyName);
            Table table = this.analyzer.table(dependency, typeName, this.id);
            if (table != null) {
                dependency.setSearchTable(this.analyzer, table, pk, Relation.Direction.EXPORT);
                association = this.feature.addAssociation(table.featureType);
            } else {
                association = this.feature.addAssociation(typeName);
            }
            association.setName((CharSequence)propertyName).setMinimumOccurs(0).setMaximumOccurs(Integer.MAX_VALUE);
        }
        return pk;
    }

    private void updateCaseHeuristic(String column) {
        if (!column.isEmpty()) {
            int firstLetter = column.codePointAt(0);
            if (Character.isLowerCase(firstLetter)) {
                ++this.countLowerCaseStarts;
            } else if (Character.isUpperCase(firstLetter) && !CharSequences.isUpperCase((CharSequence)column)) {
                --this.countLowerCaseStarts;
            }
        }
    }

    private String toHeuristicLabel(String propertyName) {
        if (this.countLowerCaseStarts > 0) {
            CharSequence words = CharSequences.camelCaseToWords((CharSequence)propertyName, (boolean)true);
            int first = Character.codePointAt(words, 0);
            propertyName = new StringBuilder(words.length()).appendCodePoint(Character.toLowerCase(first)).append(words, Character.charCount(first), words.length()).toString();
        }
        return propertyName;
    }

    final DataStoreContentException duplicatedColumn(Column column) {
        return new DataStoreContentException(this.analyzer.resources().getString((short)5, column.name));
    }

    String getRemarks() throws SQLException {
        return this.id.freeText;
    }

    final DefaultFeatureType buildFeatureType() throws DataStoreException, SQLException {
        String remarks = this.id.freeText;
        if (remarks != null) {
            this.feature.setDefinition((CharSequence)remarks);
        }
        this.feature.setName(this.id.getName(this.analyzer));
        SchemaModifier customizer = this.analyzer.customizer;
        return customizer != null ? customizer.editFeatureType(this.id, this.feature) : this.feature.build();
    }
}

