/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.math.Fraction;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class Robinson
extends NormalizedProjection {
    private static final long serialVersionUID = -2998244461334786203L;
    private static final int LATITUDE_INCREMENT = 5;
    private static final Fraction TO_INDEX = new Fraction(1, 5);
    private static final Fraction XF = new Fraction(8487, 10000);
    private static final Fraction YF = new Fraction(13523, 10000);
    private static final double[] TABLE = new double[]{0.9986, -0.062, 1.0, 0.0, 0.9986, 0.062, 0.9954, 0.124, 0.99, 0.186, 0.9822, 0.248, 0.973, 0.31, 0.96, 0.372, 0.9427, 0.434, 0.9216, 0.4958, 0.8962, 0.5571, 0.8679, 0.6176, 0.835, 0.6769, 0.7986, 0.7346, 0.7597, 0.7903, 0.7186, 0.8435, 0.6732, 0.8936, 0.6213, 0.9394, 0.5722, 0.9761, 0.5322, 1.0};
    private static final int LAST_INDEX = 17;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.Robinson.CENTRAL_MERIDIAN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.Robinson.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.Robinson.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, Variant.ROBINSON);
    }

    public Robinson(OperationMethod method, Parameters parameters) {
        super(Robinson.initializer(method, parameters), null);
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        normalize.convertAfter(0, (Number)DoubleDouble.DEGREES_TO_RADIANS, null);
        normalize.convertAfter(1, (Number)TO_INDEX, null);
        denormalize.convertBefore(0, (Number)XF, null);
        denormalize.convertBefore(1, (Number)YF, null);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6m = srcPts[srcOff + 1];
        double \u03c6a = Math.abs(\u03c6m);
        int i = Math.min((int)\u03c6a, 17);
        double p = \u03c6a - (double)i;
        double tb = TABLE[i <<= 1];
        double t0 = TABLE[i + 2];
        double t1 = TABLE[i + 4];
        double xp1 = t1 - tb;
        double xp2 = p * (t1 - 2.0 * t0 + tb);
        double xr = t0 + p * (xp1 + xp2) / 2.0;
        tb = TABLE[i + 1];
        t0 = TABLE[i + 3];
        t1 = TABLE[i + 5];
        double yp1 = t1 - tb;
        double yp2 = p * (t1 - 2.0 * t0 + tb);
        double ya = t0 + p * (yp1 + yp2) / 2.0;
        if (dstPts != null) {
            dstPts[dstOff] = xr * \u03bb;
            dstPts[dstOff + 1] = Math.copySign(ya, \u03c6m);
        }
        if (!derivate) {
            return null;
        }
        return new Matrix2(xr, (xp1 / 2.0 + xp2) * Math.abs(\u03bb), 0.0, yp1 / 2.0 + yp2);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double c;
        double ym;
        double y1;
        double u;
        int ti;
        double y0;
        double t;
        double p;
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double ya = Math.abs(y);
        int i = Math.min((int)(ya * 18.0), 17);
        while ((p = (t = 2.0 * (ya - (y0 = TABLE[(ti = i << 1 | 1) + 2])) / (u = (y1 = TABLE[ti + 4]) - (ym = TABLE[ti]))) * (1.0 - (c = t * (y1 - 2.0 * y0 + ym) / u) * (1.0 - 2.0 * c))) < 0.0 && --i >= 0) {
        }
        i = Math.max(i, 0);
        int nbIter = 18;
        double \u03c6m = p + (double)i;
        do {
            double tb = TABLE[(i <<= 1) + 1];
            double t0 = TABLE[i + 3];
            double t1 = TABLE[i + 5];
            double yp1 = t1 - tb;
            double yp2 = p * (t1 - 2.0 * t0 + tb);
            double err = t0 + p * (yp1 + yp2) / 2.0 - ya;
            double dy = yp1 / 2.0 + yp2;
            \u03c6m -= err / dy;
            if (!(Math.abs(err) > 3.926676682852614E-10)) {
                tb = TABLE[i + 0];
                t0 = TABLE[i + 2];
                t1 = TABLE[i + 4];
                dstPts[dstOff] = x / (t0 + p * (t1 - tb + p * (t1 - 2.0 * t0 + tb)) / 2.0);
                dstPts[dstOff + 1] = Math.copySign(\u03c6m, y);
                return;
            }
            i = Math.min((int)\u03c6m, 17);
            p = \u03c6m - (double)i;
        } while (--nbIter >= 0);
        throw new ProjectionException(Resources.format((short)46));
    }

    private static enum Variant implements ProjectionVariant
    {
        ROBINSON;


        @Override
        public boolean useAuthalicRadius() {
            return true;
        }

        @Override
        public boolean useRadians() {
            return false;
        }
    }
}

