/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.HashMap;
import java.util.Set;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.GetterNode;
import org.apache.royale.compiler.internal.tree.as.SetterNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class AccessorEmitter
extends JSSubEmitter
implements ISubEmitter<IAccessorNode> {
    public AccessorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IAccessorNode node) {
        if (node.getNodeID() == ASTNodeID.GetterID) {
            this.emitGet((IGetterNode)node);
        } else if (node.getNodeID() == ASTNodeID.SetterID) {
            this.emitSet((ISetterNode)node);
        }
    }

    @Override
    public void emit(IClassDefinition definition) {
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        boolean emitExports = true;
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
        }
        if (!this.getModel().getPropertyMap().isEmpty()) {
            this.writeProperties(definition, emitExports);
        }
        if (!this.getModel().getPropertyMap().isEmpty() && !this.getModel().isExterns) {
            this.writeDefineProperties(definition);
        }
        if (!this.getModel().getStaticPropertyMap().isEmpty()) {
            this.writeStaticProperties(definition, emitExports);
        }
        if (!this.getModel().getStaticPropertyMap().isEmpty() && !this.getModel().isExterns) {
            this.writeStaticDefineProperties(definition);
        }
    }

    public void emitGet(IGetterNode node) {
        JSSessionModel.PropertyNodes p;
        IFunctionDefinition def;
        ModifiersSet modifierSet;
        boolean suppress;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        boolean bl = suppress = this.getModel().suppressExports || ASNodeUtils.hasExportSuppressed((IDocumentableDefinitionNode)node);
        if (suppress) {
            this.getModel().suppressedExportNodes.add((IASNode)node);
        }
        boolean isStatic = (modifierSet = (def = node.getDefinition()).getModifiers()) != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        String name = node.getName();
        if (!isStatic && def != null && def.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
            name = fjs.formatPrivateName(def.getParent().getQualifiedName(), name);
        }
        String uri = null;
        Object key = name;
        if (!def.getNamespaceReference().isLanguageNamespace()) {
            uri = ((INamespaceDefinition)((GetterNode)node).getActualNamespaceNode().resolve(this.getProject())).getURI();
            key = uri + "::" + name;
        }
        boolean emitExports = true;
        boolean exportProtected = false;
        boolean exportInternal = false;
        boolean preventRenamePublicSymbols = true;
        boolean preventRenameProtectedSymbols = true;
        boolean preventRenameInternalSymbols = true;
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
            exportProtected = project.config.getExportProtectedSymbols();
            exportInternal = project.config.getExportInternalSymbols();
            preventRenamePublicSymbols = project.config.getPreventRenamePublicSymbols();
            preventRenameProtectedSymbols = project.config.getPreventRenameProtectedSymbols();
            preventRenameInternalSymbols = project.config.getPreventRenameInternalSymbols();
        }
        if ((p = map.get(key)) == null) {
            p = new JSSessionModel.PropertyNodes();
            p.name = name;
            p.originalName = node.getName();
            p.uri = uri;
            map.put((String)key, p);
        }
        if (uri != null || def.isPublic()) {
            p.resolvedExport = p.resolvedExport || emitExports;
            p.preventRename = p.preventRename || preventRenamePublicSymbols;
        } else if (def.isInternal()) {
            p.resolvedExport = p.resolvedExport || exportInternal;
            p.preventRename = p.preventRename || preventRenameInternalSymbols;
        } else if (def.isProtected()) {
            p.resolvedExport = p.resolvedExport || exportProtected;
            p.preventRename = p.preventRename || preventRenameProtectedSymbols;
        }
        p.getter = node;
        if (!p.suppressExport) {
            p.suppressExport = suppress;
        }
        if (p.type == null && project != null) {
            p.type = node.getDefinition().resolveReturnType((ICompilerProject)project);
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
    }

    public void emitSet(ISetterNode node) {
        JSSessionModel.PropertyNodes p;
        IFunctionDefinition def;
        ModifiersSet modifierSet;
        boolean suppress;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)fjs.getDocEmitter();
        boolean bl = suppress = this.getModel().suppressExports || ASNodeUtils.hasExportSuppressed((IDocumentableDefinitionNode)node);
        if (suppress) {
            this.getModel().suppressedExportNodes.add((IASNode)node);
        }
        boolean isStatic = (modifierSet = (def = node.getDefinition()).getModifiers()) != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        String name = node.getName();
        if (!isStatic && def != null && def.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
            name = fjs.formatPrivateName(def.getParent().getQualifiedName(), name);
        }
        String uri = null;
        Object key = name;
        if (!def.getNamespaceReference().isLanguageNamespace()) {
            uri = ((INamespaceDefinition)((SetterNode)node).getActualNamespaceNode().resolve(this.getProject())).getURI();
            key = uri + "::" + name;
        }
        boolean emitExports = true;
        boolean exportProtected = false;
        boolean exportInternal = false;
        boolean preventRenamePublicSymbols = true;
        boolean preventRenameProtectedSymbols = true;
        boolean preventRenameInternalSymbols = true;
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
            exportProtected = project.config.getExportProtectedSymbols();
            exportInternal = project.config.getExportInternalSymbols();
            preventRenamePublicSymbols = project.config.getPreventRenamePublicSymbols();
            preventRenameProtectedSymbols = project.config.getPreventRenameProtectedSymbols();
            preventRenameInternalSymbols = project.config.getPreventRenameInternalSymbols();
        }
        if ((p = map.get(key)) == null) {
            p = new JSSessionModel.PropertyNodes();
            p.name = name;
            p.originalName = node.getName();
            p.uri = uri;
            map.put((String)key, p);
        }
        if (uri != null || def.isPublic()) {
            p.resolvedExport = p.resolvedExport || emitExports;
            p.preventRename = p.preventRename || preventRenamePublicSymbols;
        } else if (def.isInternal()) {
            p.resolvedExport = p.resolvedExport || exportInternal;
            p.preventRename = p.preventRename || preventRenameInternalSymbols;
        } else if (def.isProtected()) {
            p.resolvedExport = p.resolvedExport || exportProtected;
            p.preventRename = p.preventRename || preventRenameProtectedSymbols;
        }
        p.setter = node;
        if (!p.suppressExport) {
            p.suppressExport = suppress;
        }
        if (p.type == null && project != null) {
            IParameterDefinition[] params = def.getParameters();
            p.type = params[0].resolveType((ICompilerProject)project);
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
        boolean isBindableSetter = false;
        if (node instanceof SetterNode) {
            IMetaInfo[] metaInfos = null;
            for (IMetaInfo metaInfo : metaInfos = node.getMetaInfos()) {
                name = metaInfo.getTagName();
                if (!name.equals("Bindable") || metaInfo.getAllAttributes().length != 0) continue;
                isBindableSetter = true;
                break;
            }
        }
        if (isBindableSetter) {
            IFunctionDefinition definition = node.getDefinition();
            ITypeDefinition type = (ITypeDefinition)definition.getParent();
            doc.emitMethodDoc((IFunctionNode)fn, this.getProject());
            this.write(fjs.formatQualifiedName(type.getQualifiedName()));
            if (!node.hasModifier(ASModifier.STATIC)) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write("__bindingWrappedSetter__");
            this.writeToken(node.getName());
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            fjs.emitParameters(node.getParametersContainerNode());
            fjs.emitMethodScope(node.getScopedNode());
            this.writeNewline();
        }
    }

    private void writeProperties(IClassDefinition definition, boolean emitExports) {
        Set<String> propertyNames = this.getModel().getPropertyMap().keySet();
        for (String propName : propertyNames) {
            JSSessionModel.PropertyNodes p = this.getModel().getPropertyMap().get(propName);
            if (this.getModel().isExterns) {
                this.writeExternPropertyNodes(p, definition, emitExports);
                continue;
            }
            this.writePropertyNodes(p, definition);
        }
    }

    private void writeStaticProperties(IClassDefinition definition, boolean emitExports) {
        Set<String> propertyNames = this.getModel().getStaticPropertyMap().keySet();
        for (String propName : propertyNames) {
            JSSessionModel.PropertyNodes p = this.getModel().getStaticPropertyMap().get(propName);
            if (this.getModel().isExterns) {
                this.writeExternPropertyNodesStatic(p, definition, emitExports);
                continue;
            }
            this.writePropertyNodesStatic(p, definition);
        }
    }

    private void writeDefineProperties(IClassDefinition definition) {
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTIES);
        this.write(ASEmitterTokens.PAREN_OPEN);
        String qname = definition.getQualifiedName();
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + ".prototype} */ ");
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
        Set<String> propertyNames = this.getModel().getPropertyMap().keySet();
        boolean firstTime = true;
        for (String propName : propertyNames) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            JSSessionModel.PropertyNodes p = this.getModel().getPropertyMap().get(propName);
            this.writeDefinePropertyNodes(p, definition);
        }
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writeStaticDefineProperties(IClassDefinition definition) {
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTIES);
        this.write(ASEmitterTokens.PAREN_OPEN);
        String qname = definition.getQualifiedName();
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + "} */ ");
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
        Set<String> propertyNames = this.getModel().getStaticPropertyMap().keySet();
        boolean firstTime = true;
        for (String propName : propertyNames) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            JSSessionModel.PropertyNodes p = this.getModel().getStaticPropertyMap().get(propName);
            this.writeDefinePropertyNodesStatic(p, definition);
        }
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writeGetterNode(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String qname = definition.getQualifiedName();
        String baseName = p.name;
        IGetterNode getterNode = p.getter;
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)getterNode).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatGetter(baseName), true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(fjs.formatGetter(baseName));
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        fjs.emitParameters(getterNode.getParametersContainerNode());
        fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writeSetterNode(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String qname = definition.getQualifiedName();
        String baseName = p.name;
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        boolean isClassBindable = BindableHelper.isClassCodeGenBindable((IClassDefinition)definition);
        boolean isBindable = false;
        IAccessorDefinition setterDef = (IAccessorDefinition)setterNode.getDefinition();
        IAccessorDefinition getterDef = null;
        if (getterNode != null) {
            getterDef = (IAccessorDefinition)getterNode.getDefinition();
        }
        if (getterDef != null && (setterDef.isBindable() || getterDef.isBindable())) {
            boolean foundExplicitBindableTag = false;
            if (setterDef.isBindable()) {
                isBindable = BindableHelper.isCodeGenBindableMember((IDefinition)setterDef, (boolean)isClassBindable);
                foundExplicitBindableTag = BindableHelper.hasExplicitBindable((IDefinition)setterDef);
            }
            if (getterDef.isBindable()) {
                isBindable = isBindable || BindableHelper.isCodeGenBindableMember((IDefinition)getterDef, (boolean)isClassBindable);
                boolean bl = foundExplicitBindableTag = foundExplicitBindableTag || BindableHelper.hasExplicitBindable((IDefinition)getterDef);
            }
            if (isClassBindable) {
                isBindable = !foundExplicitBindableTag;
            }
        }
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)setterNode).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatSetter(baseName), true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            if (isBindable) {
                this.write(JSRoyaleEmitterTokens.BINDABLE_PREFIX);
                this.write(fjs.formatSetter(fjs.formatPrivateName(definition.getQualifiedName(), baseName, true)));
            } else {
                this.write(fjs.formatSetter(baseName));
            }
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        fjs.emitParameters(setterNode.getParametersContainerNode());
        fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
        this.write(ASEmitterTokens.SEMICOLON);
        if (isBindable) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(fjs.formatSetter(baseName));
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write("value");
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            this.write(ASEmitterTokens.VAR);
            this.write(ASEmitterTokens.SPACE);
            this.write("oldValue");
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(fjs.formatGetter(baseName));
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.write(ASEmitterTokens.IF);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write("oldValue != value");
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSRoyaleEmitterTokens.BINDABLE_PREFIX);
            this.write(fjs.formatSetter(fjs.formatPrivateName(definition.getQualifiedName(), baseName, true)));
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write("value");
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.writeNewline("    this.dispatchEvent(" + fjs.formatQualifiedName(BindableEmitter.VALUECHANGE_EVENT_QNAME) + ".createUpdateEvent(");
            this.writeNewline("         this, \"" + p.originalName + "\", oldValue, value));");
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    private void writeStaticGetterNode(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String qname = definition.getQualifiedName();
        String baseName = p.name;
        IGetterNode getterNode = p.getter;
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(this.getEmitter().formatQualifiedName(qname));
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)getterNode).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatGetter(baseName), true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(fjs.formatGetter(baseName));
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        fjs.emitParameters(getterNode.getParametersContainerNode());
        fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writeStaticSetterNode(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String qname = definition.getQualifiedName();
        String baseName = p.name;
        ISetterNode setterNode = p.setter;
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.write(this.getEmitter().formatQualifiedName(qname));
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)setterNode).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatSetter(baseName), true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(fjs.formatSetter(baseName));
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        fjs.emitParameters(setterNode.getParametersContainerNode());
        fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writePropertyNodes(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        IGetterNode accessorNode;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String baseName = p.name;
        String qname = definition.getQualifiedName();
        Object object = accessorNode = getterNode != null ? getterNode : setterNode;
        if (!accessorNode.getDefinition().isOverride()) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.writeNewline("/**");
            if (p.preventRename) {
                this.writeNewline(" * @nocollapse");
            }
            if (p.resolvedExport && !p.suppressExport) {
                this.writeNewline(" * @export");
            }
            if (p.type != null) {
                this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
            }
            this.writeNewline(" */");
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            if (p.uri != null) {
                INamespaceDecorationNode ns = ((FunctionNode)accessorNode).getActualNamespaceNode();
                INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
            } else {
                this.write(baseName);
            }
            this.write(ASEmitterTokens.SEMICOLON);
        }
        if (getterNode != null) {
            this.writeGetterNode(p, definition);
        }
        if (setterNode != null) {
            this.writeSetterNode(p, definition);
        }
    }

    private void writeExternPropertyNodes(JSSessionModel.PropertyNodes p, IClassDefinition definition, boolean emitExports) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String baseName = p.name;
        String qname = definition.getQualifiedName();
        IGetterNode node = getterNode != null ? getterNode : setterNode;
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline("/**");
        if (emitExports) {
            this.writeNewline(" * @export");
        }
        if (p.type != null) {
            this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
        }
        this.writeNewline(" */");
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(baseName);
        }
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writePropertyNodesStatic(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String baseName = p.name;
        String qname = definition.getQualifiedName();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * @nocollapse");
        if (p.resolvedExport && !p.suppressExport) {
            this.writeNewline(" * @export");
        }
        if (p.type != null) {
            this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
        }
        this.writeNewline(" */");
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        if (p.uri != null) {
            IGetterNode node = getterNode != null ? getterNode : setterNode;
            INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
        } else {
            this.write(baseName);
        }
        this.write(ASEmitterTokens.SEMICOLON);
        if (getterNode != null) {
            this.writeStaticGetterNode(p, definition);
        }
        if (setterNode != null) {
            this.writeStaticSetterNode(p, definition);
        }
    }

    private void writeExternPropertyNodesStatic(JSSessionModel.PropertyNodes p, IClassDefinition definition, boolean emitExports) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String baseName = p.name;
        String qname = definition.getQualifiedName();
        IGetterNode node = getterNode != null ? getterNode : setterNode;
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline("/**");
        if (emitExports) {
            this.writeNewline(" * @export");
        }
        if (p.type != null) {
            this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
        }
        this.writeNewline(" */");
        this.write(this.getEmitter().formatQualifiedName(qname));
        if (p.uri != null) {
            INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, true));
        } else {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(baseName);
        }
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private void writeDefinePropertyNodes(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        INamespaceDefinition nsDef;
        INamespaceDecorationNode ns;
        IAccessorDefinition other;
        INamespaceDefinition nsDef2;
        INamespaceDecorationNode ns2;
        FunctionNode fnNode;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String baseName = p.name;
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String qname = definition.getQualifiedName();
        boolean wroteGetter = false;
        this.writeNewline("/**");
        if (p.type != null) {
            String typeName = p.type.getBaseName();
            if (this.getModel().isInternalClass(typeName)) {
                typeName = this.getModel().getInternalClasses().get(typeName);
            }
            this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(typeName, p.type.getPackageName()) + "}");
        }
        this.writeNewline(" */");
        FunctionNode functionNode = fnNode = getterNode != null ? (FunctionNode)getterNode : (FunctionNode)setterNode;
        if (p.uri != null) {
            ns2 = fnNode.getActualNamespaceNode();
            nsDef2 = (INamespaceDefinition)ns2.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef2.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
        } else {
            this.write(baseName);
        }
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.writeNewline();
        if (getterNode != null) {
            this.write(ASEmitterTokens.GET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            if (p.uri != null) {
                ns2 = ((FunctionNode)getterNode).getActualNamespaceNode();
                nsDef2 = (INamespaceDefinition)ns2.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef2.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatGetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatGetter(baseName));
            }
            wroteGetter = true;
        } else if (setterNode != null && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p.setter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
            this.write(ASEmitterTokens.GET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(other.getParent().getQualifiedName()));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            if (p.uri != null) {
                ns = ((FunctionNode)setterNode).getActualNamespaceNode();
                nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatGetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatGetter(baseName));
            }
            wroteGetter = true;
        }
        if (setterNode != null) {
            if (wroteGetter) {
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            this.write(ASEmitterTokens.SET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            if (p.uri != null) {
                ns2 = ((FunctionNode)setterNode).getActualNamespaceNode();
                nsDef2 = (INamespaceDefinition)ns2.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef2.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatSetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatSetter(baseName));
            }
        } else if (getterNode != null && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p.getter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
            if (wroteGetter) {
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            this.write(ASEmitterTokens.SET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(other.getParent().getQualifiedName()));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            if (p.uri != null) {
                ns = ((FunctionNode)getterNode).getActualNamespaceNode();
                nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatSetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatSetter(baseName));
            }
        }
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    private void writeDefinePropertyNodesStatic(JSSessionModel.PropertyNodes p, IClassDefinition definition) {
        INamespaceDefinition nsDef;
        INamespaceDecorationNode ns;
        FunctionNode fnNode;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IGetterNode getterNode = p.getter;
        ISetterNode setterNode = p.setter;
        String baseName = p.name;
        String qname = definition.getQualifiedName();
        this.writeNewline("/**");
        if (p.type != null) {
            this.writeNewline(" * @type {" + JSRoyaleDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
        }
        this.writeNewline(" */");
        FunctionNode functionNode = fnNode = getterNode != null ? (FunctionNode)getterNode : (FunctionNode)setterNode;
        if (p.uri != null) {
            ns = fnNode.getActualNamespaceNode();
            nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
        } else {
            this.write(baseName);
        }
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.writeNewline();
        if (getterNode != null) {
            this.write(ASEmitterTokens.GET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(qname));
            if (p.uri != null) {
                ns = ((FunctionNode)getterNode).getActualNamespaceNode();
                nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatGetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatGetter(baseName));
            }
        }
        if (setterNode != null) {
            if (p.getter != null) {
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            this.write(ASEmitterTokens.SET);
            this.write(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(qname));
            if (p.uri != null) {
                ns = ((FunctionNode)setterNode).getActualNamespaceNode();
                nsDef = (INamespaceDefinition)ns.resolve(this.getWalker().getProject());
                fjs.formatQualifiedName(nsDef.getQualifiedName());
                this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, fjs.formatSetter(baseName), true));
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatSetter(baseName));
            }
        }
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }
}

