/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import java.util.Collection;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.royale.compiler.internal.as.codegen.ICodeGenerator;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.CatchScope;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

public class VariableDefinition
extends DefinitionBase
implements IVariableDefinition {
    protected Object initValue;
    private boolean mxmlDeclared = false;
    private IExpressionNode initializer;

    public VariableDefinition(String name) {
        super(name);
    }

    public VariableDefinition(String name, Object initialValue) {
        this(name);
        this.initValue = initialValue;
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        ASScope containingScope = this.getContainingASScope();
        if (containingScope instanceof FunctionScope) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        if (containingScope instanceof CatchScope) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        IDefinition parent = this.getParent();
        if (parent instanceof IClassDefinition) {
            return IVariableDefinition.VariableClassification.CLASS_MEMBER;
        }
        if (parent instanceof IPackageDefinition) {
            return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
        }
        if (parent == null) {
            if (this.inPackageNamespace()) {
                return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
            }
            return IVariableDefinition.VariableClassification.FILE_MEMBER;
        }
        assert (false);
        return null;
    }

    @Override
    protected DependencyType getTypeDependencyType() {
        DependencyType dt = DependencyType.EXPRESSION;
        if (this.getVariableClassification() != IVariableDefinition.VariableClassification.LOCAL) {
            dt = DependencyType.SIGNATURE;
        }
        return dt;
    }

    public void setMxmlDeclared() {
        this.mxmlDeclared = true;
    }

    public boolean isMXMLDeclared() {
        return this.mxmlDeclared;
    }

    @Override
    public IVariableNode getNode() {
        return (IVariableNode)super.getNode();
    }

    private IVariableNode getNodeIfExists() {
        return (IVariableNode)this.nodeRef.getNodeIfExists();
    }

    @Override
    public IVariableNode getVariableNode() {
        return this.getNode();
    }

    @Override
    public boolean matches(DefinitionBase node) {
        boolean matches = super.matches(node);
        if (!matches) {
            return false;
        }
        if (node == this) {
            return true;
        }
        VariableDefinition vNode = (VariableDefinition)node;
        IVariableDefinition.VariableClassification classification = vNode.getVariableClassification();
        if (classification != this.getVariableClassification()) {
            return false;
        }
        return classification != IVariableDefinition.VariableClassification.LOCAL && classification != IVariableDefinition.VariableClassification.FILE_MEMBER && classification != IVariableDefinition.VariableClassification.PARAMETER && classification != IVariableDefinition.VariableClassification.CLASS_MEMBER && classification != IVariableDefinition.VariableClassification.INTERFACE_MEMBER || vNode.getNameStart() == this.getNameStart() && vNode.getNameEnd() == this.getNameEnd();
    }

    @Override
    protected void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("var");
        sb.append(' ');
        sb.append(this.getBaseName());
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public TypeDefinitionBase resolveType(ICompilerProject project) {
        ITypeDefinition typeDef;
        IVariableNode varNode;
        if (project.getInferTypes() && this.getTypeReference() == null && (varNode = this.getNode()) != null && (typeDef = SemanticUtils.resolveVariableInferredType(varNode, project)) != null) {
            this.setTypeReference(ReferenceFactory.resolvedReference(typeDef));
            return (TypeDefinitionBase)typeDef;
        }
        return super.resolveType(project);
    }

    public IExpressionNode getInitializer() {
        return this.initializer;
    }

    public void setInitializer(IExpressionNode initExpr) {
        if (initExpr != null) {
            if (initExpr instanceof LiteralNode) {
                switch (initExpr.getNodeID()) {
                    case LiteralBooleanID: {
                        this.initValue = SemanticUtils.getBooleanContent(initExpr);
                        return;
                    }
                    case LiteralDoubleID: {
                        this.initValue = SemanticUtils.getDoubleContent(initExpr);
                        return;
                    }
                    case LiteralStringID: {
                        this.initValue = SemanticUtils.getStringLiteralContent(initExpr);
                        return;
                    }
                    case LiteralIntegerID: {
                        this.initValue = SemanticUtils.getIntegerContent(initExpr);
                        return;
                    }
                    case LiteralNullID: {
                        this.initValue = ABCConstants.NULL_VALUE;
                        return;
                    }
                    case LiteralUintID: {
                        this.initValue = SemanticUtils.getUintContent(initExpr);
                        return;
                    }
                }
            }
            this.setHasInit();
            if (this.getVariableClassification() != IVariableDefinition.VariableClassification.LOCAL) {
                this.initializer = initExpr.copyForInitializer(new DefinitionScopedNode());
            }
        }
    }

    private void setHasInit() {
        this.flags = (short)(this.flags | 0x1000);
    }

    boolean hasInit() {
        return (this.flags & 0x1000) != 0;
    }

    @Override
    public Object resolveInitialValue(ICompilerProject project) {
        ICodeGenerator codeGenerator;
        ICodeGenerator.IConstantValue constantValue;
        if (this.initValue != null) {
            return this.initValue;
        }
        IExpressionNode initExpr = this.getInitExpression();
        if (initExpr != null && (constantValue = (codeGenerator = CodeGeneratorManager.getCodeGenerator()).generateConstantValue(initExpr, project)) != null) {
            return constantValue.getValue();
        }
        return null;
    }

    protected IExpressionNode getInitExpression() {
        IExpressionNode init = null;
        if (this.hasInit()) {
            if (this.getVariableClassification() == IVariableDefinition.VariableClassification.LOCAL) {
                IVariableNode n = this.getNodeIfExists();
                assert (n != null) : "The AST for a local var should still be in memory!";
                init = n.getAssignedValueNode();
            } else {
                init = this.initializer;
            }
        }
        return init;
    }

    @Override
    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    @Override
    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    public void setDeclaredInControlFlow(boolean b) {
        this.flags = b ? (short)(this.flags | 0x4000) : (short)(this.flags & 0xFFFFBFFF);
    }

    public boolean declaredInControlFlow() {
        return (this.flags & 0x4000) != 0;
    }

    private class DefinitionScopedNode
    extends NodeBase
    implements IScopedNode {
        private DefinitionScopedNode() {
        }

        @Override
        public IASScope getScope() {
            return VariableDefinition.this.getContainingASScope();
        }

        @Override
        public void getAllImports(Collection<String> imports) {
        }

        @Override
        public void getAllImportNodes(Collection<IImportNode> imports) {
        }

        @Override
        public ASTNodeID getNodeID() {
            return ASTNodeID.UnknownID;
        }
    }
}

