/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.lang.reflect.Constructor;
import org.apache.royale.compiler.internal.as.codegen.CmcEmitter;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;

class UnknownTreeFinding {
    final ICompilerProblem problem;
    final boolean provisional;

    UnknownTreeFinding(ICompilerProblem problem, boolean provisional) {
        this.problem = problem;
        this.provisional = provisional;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.problem.getClass().getName());
        buff.append("@");
        buff.append(Integer.toHexString(System.identityHashCode(this)));
        buff.append(", p:");
        buff.append(this.provisional);
        return buff.toString();
    }

    static class Template {
        ASTNodeID id = ASTNodeID.UnknownID;
        Class<? extends Object> nodeClass = null;
        int mustHaveState = -1;
        int cantHaveState = -1;
        Template requiredSubtree = null;
        Class<? extends Object> problemClass;
        boolean provisional = false;

        Template() {
        }

        boolean matches(CmcEmitter.JBurgAnnotation annotation) {
            if (this.id != annotation.getNode().getNodeID() && this.id != ASTNodeID.UnknownID) {
                return false;
            }
            if (this.mustHaveState != -1 && annotation.getCost(this.mustHaveState) >= Integer.MAX_VALUE) {
                return false;
            }
            if (this.cantHaveState != -1 && annotation.getCost(this.cantHaveState) < Integer.MAX_VALUE) {
                return false;
            }
            if (this.nodeClass != null && !this.nodeClass.isInstance(annotation.getNode())) {
                return false;
            }
            if (this.requiredSubtree != null) {
                boolean found_match = false;
                for (int i = 0; !found_match && i < annotation.getArity(); found_match |= this.requiredSubtree.matches(annotation.getNthChild(i)), ++i) {
                }
                return found_match;
            }
            return true;
        }

        CmcEmitter.JBurgAnnotation getInnermostMatchedNode(CmcEmitter.JBurgAnnotation annotation) {
            if (this.requiredSubtree != null) {
                for (int i = 0; i < annotation.getArity(); ++i) {
                    if (!this.requiredSubtree.matches(annotation.getNthChild(i))) continue;
                    return this.requiredSubtree.getInnermostMatchedNode(annotation.getNthChild(i));
                }
                assert (false) : "Required subtree not present";
            }
            return annotation;
        }

        UnknownTreeFinding createFinding(CmcEmitter.JBurgAnnotation problem_node) throws Exception {
            Constructor<? extends Object> ctor = this.problemClass.getDeclaredConstructor(IASNode.class);
            ICompilerProblem problem = (ICompilerProblem)ctor.newInstance(problem_node.getNode());
            return new UnknownTreeFinding(problem, this.provisional);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append((Object)this.id);
            if (this.cantHaveState != -1) {
                buf.append(",ch:");
                buf.append(this.cantHaveState);
            }
            if (this.mustHaveState != -1) {
                buf.append(",mh:");
                buf.append(this.mustHaveState);
            }
            if (this.nodeClass != null) {
                buf.append(",nc: ");
                buf.append(this.nodeClass.getName());
            }
            buf.append("@");
            buf.append(Integer.toHexString(System.identityHashCode(this)));
            if (this.requiredSubtree != null) {
                buf.append("(" + this.requiredSubtree + ")");
            }
            return buf.toString();
        }
    }
}

