/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.util.StringUtil;

public final class ObjectProperties {
    static final String EMPTY_STRING = "";
    private final Set<String> _attributeNames = new HashSet<String>();
    private final EnumMap<Property, Object> _properties = new EnumMap(Property.class);
    private String _description = "";

    public ObjectProperties() {
    }

    public ObjectProperties(Property property, String value) {
        this.put(property, value);
    }

    public ObjectProperties(ObjectProperties copy) {
        if (copy != null) {
            this._properties.putAll(copy._properties);
            this._attributeNames.addAll(copy._attributeNames);
            this._description = copy._description;
        }
    }

    public ObjectProperties(String name) {
        this.setName(name);
    }

    public ObjectProperties withDescription(String description) {
        this._description = description == null ? EMPTY_STRING : description;
        return this;
    }

    public Object get(Property key) {
        return this._properties.get((Object)key);
    }

    public Map<Property, Object> getAll() {
        return new EnumMap<Property, Object>(this._properties);
    }

    public void setName(String name) {
        this._properties.put(Property.NAME, (Object)(name == null ? EMPTY_STRING : name));
    }

    public void setCreatedBy(Object user) {
        if (user != null) {
            this.put(Property.CREATED_BY, user.toString());
        }
    }

    public void setOwner(Object owner) {
        if (owner != null) {
            this.put(Property.OWNER, owner.toString());
        }
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this._attributeNames);
    }

    public void addAttributeNames(Collection<String> attributeNames) {
        if (attributeNames != null && !attributeNames.isEmpty()) {
            this._attributeNames.addAll(attributeNames);
        }
    }

    public void addAttributeNames(String ... attributeNames) {
        if (attributeNames != null && attributeNames.length > 0) {
            this._attributeNames.addAll(Arrays.asList(attributeNames));
        }
    }

    public Object put(Property key, String value) {
        return this._properties.put(key, (Object)(value == null ? EMPTY_STRING : value.trim()));
    }

    public Object put(Property key, boolean value) {
        return this._properties.put(key, (Object)value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectProperties) {
            ObjectProperties that = (ObjectProperties)o;
            return this._attributeNames.equals(that._attributeNames) && this._properties.equals((Object)that._properties);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this._attributeNames.hashCode() + this._properties.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectProperties[");
        if (!this._properties.isEmpty()) {
            sb.append("properties=[");
            sb.append(StringUtil.join(this._properties, (String)",", (String)"="));
            sb.append("]");
        }
        if (!this._attributeNames.isEmpty()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(Property.ATTRIBUTES.name());
            sb.append("=[");
            sb.append(StringUtil.join(this._attributeNames, (String)",", (String)"="));
            sb.append("]");
        }
        if (!this._description.isEmpty()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(this._description);
        }
        sb.append("]");
        return sb.toString();
    }
}

