/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PanicStatus implements Message {

  // Properties.
  protected final short status;

  public PanicStatus(short status) {
    super();
    this.status = status;
  }

  public short getStatus() {
    return status;
  }

  public boolean getIsNoPanic() {
    return (boolean) ((getStatus()) == (0x00));
  }

  public boolean getIsReserved() {
    return (boolean) (((getStatus()) >= (0x01)) && ((getStatus()) <= (0xFE)));
  }

  public boolean getIsPanicCurrentlyActive() {
    return (boolean) ((getStatus()) > (0xFE));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PanicStatus");

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNoPanic = getIsNoPanic();
    writeBuffer.writeVirtual("isNoPanic", isNoPanic);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPanicCurrentlyActive = getIsPanicCurrentlyActive();
    writeBuffer.writeVirtual("isPanicCurrentlyActive", isPanicCurrentlyActive);

    writeBuffer.popContext("PanicStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PanicStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (status)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static PanicStatus staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("PanicStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short status = readSimpleField("status", readUnsignedShort(readBuffer, 8));
    boolean isNoPanic = readVirtualField("isNoPanic", boolean.class, (status) == (0x00));
    boolean isReserved =
        readVirtualField("isReserved", boolean.class, ((status) >= (0x01)) && ((status) <= (0xFE)));
    boolean isPanicCurrentlyActive =
        readVirtualField("isPanicCurrentlyActive", boolean.class, (status) > (0xFE));

    readBuffer.closeContext("PanicStatus");
    // Create the instance
    PanicStatus _panicStatus;
    _panicStatus = new PanicStatus(status);
    return _panicStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PanicStatus)) {
      return false;
    }
    PanicStatus that = (PanicStatus) o;
    return (getStatus() == that.getStatus()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
