/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CRCOutputStream
extends OutputStream {
    OutputStream os = null;
    private CRC32 crc = null;
    boolean autoFlush = false;
    long bytesWritten = 0L;

    public CRCOutputStream(OutputStream os) {
        this(os, false);
    }

    public CRCOutputStream(OutputStream os, boolean autoFlush) {
        this.os = os;
        this.crc = new CRC32();
        this.autoFlush = autoFlush;
        this.bytesWritten = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.crc.update(b);
        this.os.write(b);
        if (this.autoFlush) {
            this.os.flush();
        }
        ++this.bytesWritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.crc.update(b, off, len);
        this.os.write(b, 0, len);
        if (this.autoFlush) {
            this.os.flush();
        }
        this.bytesWritten += (long)len;
    }

    public long getCRCValue() {
        return this.crc.getValue();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

