/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.net.URISyntaxException;
import java.util.List;
import org.archive.url.AggressiveIAURLCanonicalizer;
import org.archive.url.HandyURL;
import org.archive.url.RewriteRule;
import org.archive.url.URLCanonicalizer;
import org.archive.url.URLKeyMaker;
import org.archive.url.URLParser;
import org.archive.url.URLRegexTransformer;

public class WaybackURLKeyMaker
implements URLKeyMaker {
    URLCanonicalizer canonicalizer = new AggressiveIAURLCanonicalizer();
    private boolean surtMode = true;
    protected List<RewriteRule> customRules;

    public URLCanonicalizer getCanonicalizer() {
        return this.canonicalizer;
    }

    public void setCanonicalizer(URLCanonicalizer canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    public WaybackURLKeyMaker() {
    }

    public boolean isSurtMode() {
        return this.surtMode;
    }

    public WaybackURLKeyMaker(boolean surtMode) {
        this.surtMode = surtMode;
    }

    @Override
    public String makeKey(String url) throws URISyntaxException {
        if (url == null) {
            return "-";
        }
        if (url.length() == 0) {
            return "-";
        }
        if (url.startsWith("filedesc")) {
            return url;
        }
        if (url.startsWith("warcinfo")) {
            return url;
        }
        if (url.startsWith("dns:")) {
            String authority = url.substring(4);
            if (!this.surtMode) {
                return authority;
            }
            String surt = URLRegexTransformer.hostToSURT(authority);
            return surt + ")";
        }
        HandyURL hURL = URLParser.parse(url);
        this.canonicalizer.canonicalize(hURL);
        String key = hURL.getURLString(this.surtMode, this.surtMode, false);
        if (!this.surtMode) {
            return key;
        }
        int parenIdx = key.indexOf(40);
        if (parenIdx == -1) {
            return url;
        }
        key = key.substring(parenIdx + 1);
        if (this.customRules != null) {
            key = this.applyCustomRules(key);
        }
        return key;
    }

    public List<RewriteRule> getCustomRules() {
        return this.customRules;
    }

    public void setCustomRules(List<RewriteRule> customRules) {
        this.customRules = customRules;
    }

    protected String applyCustomRules(String urlkey) {
        StringBuilder sb = new StringBuilder(urlkey);
        for (RewriteRule rule : this.customRules) {
            rule.rewrite(sb);
        }
        return sb.toString();
    }
}

