/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSymbol;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArrayIterator;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class NodeList
extends AbstractList
implements Callable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList() {
    }

    public NodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive, null);
    }

    public NodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    NodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.setExternalArrayData(this);
    }

    public static NodeList staticNodeList(HtmlUnitScriptable parentScope, final List<DomNode> elements) {
        return new NodeList(parentScope){

            @Override
            public List<DomNode> getElements() {
                return elements;
            }
        };
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator keys() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator values() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator entries() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
    }

    @JsxSymbol(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator iterator() {
        return this.values();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void forEach(Object callback) {
        List<DomNode> nodes = this.getElements();
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
        ContextAction contextAction = cx -> {
            Function function = (Function)callback;
            Scriptable scope = this.getParentScope();
            for (int i = 0; i < nodes.size(); ++i) {
                function.call(cx, scope, (Scriptable)this, new Object[]{((DomNode)nodes.get(i)).getScriptableObject(), i, this});
            }
            return null;
        };
        cf.call(contextAction);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @JsxFunction
    public Object item(Object index) {
        Object object = this.getIt(index);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        Object object = this.getIt(args[0]);
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        return object;
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        return new NodeList(parentScope, new ArrayList<DomNode>(initialElements));
    }
}

