/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.analyze;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.analysis.AnalyzerComponents;
import org.opensearch.index.analysis.AnalyzerComponentsProvider;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.NameOrDefinition;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportAnalyzeAction
extends TransportSingleShardAction<AnalyzeAction.Request, AnalyzeAction.Response> {
    private final Settings settings;
    private final IndicesService indicesService;

    @Inject
    public TransportAnalyzeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/analyze", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeAction.Request::new, "analyze");
        this.settings = settings;
        this.indicesService = indicesService;
    }

    @Override
    protected Writeable.Reader<AnalyzeAction.Response> getResponseReader() {
        return AnalyzeAction.Response::new;
    }

    @Override
    protected boolean resolveIndex(AnalyzeAction.Request request) {
        return request.index() != null;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() != null) {
            return super.checkRequestBlock(state, request);
        }
        return null;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() == null) {
            return null;
        }
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected AnalyzeAction.Response shardOperation(AnalyzeAction.Request request, ShardId shardId) throws IOException {
        IndexService indexService = this.getIndexService(shardId);
        int maxTokenCount = indexService == null ? IndexSettings.MAX_TOKEN_COUNT_SETTING.get(this.settings).intValue() : indexService.getIndexSettings().getMaxTokenCount();
        return TransportAnalyzeAction.analyze(request, this.indicesService.getAnalysis(), indexService, maxTokenCount);
    }

    public static AnalyzeAction.Response analyze(AnalyzeAction.Request request, AnalysisRegistry analysisRegistry, IndexService indexService, int maxTokenCount) throws IOException {
        IndexSettings settings = indexService == null ? null : indexService.getIndexSettings();
        try (Analyzer analyzer = TransportAnalyzeAction.buildCustomAnalyzer(request, analysisRegistry, settings);){
            if (analyzer != null) {
                AnalyzeAction.Response response = TransportAnalyzeAction.analyze(request, analyzer, maxTokenCount);
                return response;
            }
        }
        return TransportAnalyzeAction.analyze(request, TransportAnalyzeAction.getAnalyzer(request, analysisRegistry, indexService), maxTokenCount);
    }

    private IndexService getIndexService(ShardId shardId) {
        if (shardId != null) {
            return this.indicesService.indexServiceSafe(shardId.getIndex());
        }
        return null;
    }

    private static Analyzer getAnalyzer(AnalyzeAction.Request request, AnalysisRegistry analysisRegistry, IndexService indexService) throws IOException {
        if (request.analyzer() != null) {
            if (indexService == null) {
                Analyzer analyzer = analysisRegistry.getAnalyzer(request.analyzer());
                if (analyzer == null) {
                    throw new IllegalArgumentException("failed to find global analyzer [" + request.analyzer() + "]");
                }
                return analyzer;
            }
            NamedAnalyzer analyzer = indexService.getIndexAnalyzers().get(request.analyzer());
            if (analyzer == null) {
                throw new IllegalArgumentException("failed to find analyzer [" + request.analyzer() + "]");
            }
            return analyzer;
        }
        if (request.normalizer() != null) {
            if (indexService == null) {
                throw new IllegalArgumentException("analysis based on a normalizer requires an index");
            }
            NamedAnalyzer analyzer = indexService.getIndexAnalyzers().getNormalizer(request.normalizer());
            if (analyzer == null) {
                throw new IllegalArgumentException("failed to find normalizer under [" + request.normalizer() + "]");
            }
            return analyzer;
        }
        if (request.field() != null) {
            if (indexService == null) {
                throw new IllegalArgumentException("analysis based on a specific field requires an index");
            }
            MappedFieldType fieldType = indexService.mapperService().fieldType(request.field());
            if (fieldType != null) {
                if (fieldType instanceof StringFieldType) {
                    return fieldType.indexAnalyzer();
                }
                throw new IllegalArgumentException("Can't process field [" + request.field() + "], Analysis requests are only supported on tokenized fields");
            }
        }
        if (indexService == null) {
            return analysisRegistry.getAnalyzer("standard");
        }
        return indexService.getIndexAnalyzers().getDefaultIndexAnalyzer();
    }

    private static Analyzer buildCustomAnalyzer(AnalyzeAction.Request request, AnalysisRegistry analysisRegistry, IndexSettings indexSettings) throws IOException {
        if (request.tokenizer() != null) {
            return analysisRegistry.buildCustomAnalyzer(indexSettings, false, request.tokenizer(), request.charFilters(), request.tokenFilters());
        }
        if (request.tokenFilters() != null && request.tokenFilters().size() > 0 || request.charFilters() != null && request.charFilters().size() > 0) {
            return analysisRegistry.buildCustomAnalyzer(indexSettings, true, new NameOrDefinition("keyword"), request.charFilters(), request.tokenFilters());
        }
        return null;
    }

    private static AnalyzeAction.Response analyze(AnalyzeAction.Request request, Analyzer analyzer, int maxTokenCount) {
        if (request.explain()) {
            return new AnalyzeAction.Response(null, TransportAnalyzeAction.detailAnalyze(request, analyzer, maxTokenCount));
        }
        return new AnalyzeAction.Response(TransportAnalyzeAction.simpleAnalyze(request, analyzer, maxTokenCount), null);
    }

    private static List<AnalyzeAction.AnalyzeToken> simpleAnalyze(AnalyzeAction.Request request, Analyzer analyzer, int maxTokenCount) {
        TokenCounter tc = new TokenCounter(maxTokenCount);
        ArrayList<AnalyzeAction.AnalyzeToken> tokens = new ArrayList<AnalyzeAction.AnalyzeToken>();
        int lastPosition = -1;
        int lastOffset = 0;
        for (String text : request.text()) {
            try (TokenStream stream = analyzer.tokenStream("", text);){
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                PositionLengthAttribute posLen = (PositionLengthAttribute)stream.addAttribute(PositionLengthAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        lastPosition += increment;
                    }
                    tokens.add(new AnalyzeAction.AnalyzeToken(term.toString(), lastPosition, lastOffset + offset.startOffset(), lastOffset + offset.endOffset(), posLen.getPositionLength(), type.type(), null));
                    tc.increment();
                }
                stream.end();
                lastOffset += offset.endOffset();
                lastPosition += posIncr.getPositionIncrement();
                lastPosition += analyzer.getPositionIncrementGap("");
                lastOffset += analyzer.getOffsetGap("");
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to analyze", (Throwable)e, new Object[0]);
            }
        }
        return tokens;
    }

    private static AnalyzeAction.DetailAnalyzeResponse detailAnalyze(AnalyzeAction.Request request, Analyzer analyzer, int maxTokenCount) {
        AnalyzeAction.DetailAnalyzeResponse detailResponse;
        HashSet<String> includeAttributes = new HashSet<String>();
        if (request.attributes() != null) {
            for (String attribute : request.attributes()) {
                includeAttributes.add(attribute.toLowerCase(Locale.ROOT));
            }
        }
        Analyzer potentialCustomAnalyzer = analyzer;
        if (analyzer instanceof NamedAnalyzer) {
            potentialCustomAnalyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (potentialCustomAnalyzer instanceof AnalyzerComponentsProvider) {
            AnalyzerComponentsProvider customAnalyzer = (AnalyzerComponentsProvider)potentialCustomAnalyzer;
            int positionIncrementGap = potentialCustomAnalyzer.getPositionIncrementGap("");
            int offsetGap = potentialCustomAnalyzer.getOffsetGap("");
            AnalyzerComponents components = customAnalyzer.getComponents();
            CharFilterFactory[] charFilterFactories = components.getCharFilters();
            TokenizerFactory tokenizerFactory = components.getTokenizerFactory();
            TokenFilterFactory[] tokenFilterFactories = components.getTokenFilters();
            String[][] charFiltersTexts = new String[charFilterFactories != null ? charFilterFactories.length : 0][request.text().length];
            TokenListCreator[] tokenFiltersTokenListCreator = new TokenListCreator[tokenFilterFactories != null ? tokenFilterFactories.length : 0];
            TokenListCreator tokenizerTokenListCreator = new TokenListCreator(maxTokenCount);
            for (int textIndex = 0; textIndex < request.text().length; ++textIndex) {
                String charFilteredSource = request.text()[textIndex];
                Reader reader = new StringReader(charFilteredSource);
                if (charFilterFactories != null) {
                    for (int charFilterIndex = 0; charFilterIndex < charFilterFactories.length; ++charFilterIndex) {
                        reader = charFilterFactories[charFilterIndex].create(reader);
                        Reader readerForWriteOut = new StringReader(charFilteredSource);
                        readerForWriteOut = charFilterFactories[charFilterIndex].create(readerForWriteOut);
                        charFiltersTexts[charFilterIndex][textIndex] = charFilteredSource = TransportAnalyzeAction.writeCharStream(readerForWriteOut);
                    }
                }
                Tokenizer tokenizer = tokenizerFactory.create();
                tokenizer.setReader(reader);
                tokenizerTokenListCreator.analyze((TokenStream)tokenizer, includeAttributes, positionIncrementGap, offsetGap);
                if (tokenFilterFactories == null) continue;
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFilterFactories.length; ++tokenFilterIndex) {
                    if (tokenFiltersTokenListCreator[tokenFilterIndex] == null) {
                        tokenFiltersTokenListCreator[tokenFilterIndex] = new TokenListCreator(maxTokenCount);
                    }
                    TokenStream stream = TransportAnalyzeAction.createStackedTokenStream(request.text()[textIndex], charFilterFactories, tokenizerFactory, tokenFilterFactories, tokenFilterIndex + 1);
                    tokenFiltersTokenListCreator[tokenFilterIndex].analyze(stream, includeAttributes, positionIncrementGap, offsetGap);
                }
            }
            AnalyzeAction.CharFilteredText[] charFilteredLists = new AnalyzeAction.CharFilteredText[charFiltersTexts.length];
            if (charFilterFactories != null) {
                for (int charFilterIndex = 0; charFilterIndex < charFiltersTexts.length; ++charFilterIndex) {
                    charFilteredLists[charFilterIndex] = new AnalyzeAction.CharFilteredText(charFilterFactories[charFilterIndex].name(), charFiltersTexts[charFilterIndex]);
                }
            }
            AnalyzeAction.AnalyzeTokenList[] tokenFilterLists = new AnalyzeAction.AnalyzeTokenList[tokenFiltersTokenListCreator.length];
            if (tokenFilterFactories != null) {
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFiltersTokenListCreator.length; ++tokenFilterIndex) {
                    tokenFilterLists[tokenFilterIndex] = new AnalyzeAction.AnalyzeTokenList(tokenFilterFactories[tokenFilterIndex].name(), tokenFiltersTokenListCreator[tokenFilterIndex].getArrayTokens());
                }
            }
            detailResponse = new AnalyzeAction.DetailAnalyzeResponse(charFilteredLists, new AnalyzeAction.AnalyzeTokenList(tokenizerFactory.name(), tokenizerTokenListCreator.getArrayTokens()), tokenFilterLists);
        } else {
            String name = analyzer instanceof NamedAnalyzer ? ((NamedAnalyzer)analyzer).name() : analyzer.getClass().getName();
            TokenListCreator tokenListCreator = new TokenListCreator(maxTokenCount);
            for (String text : request.text()) {
                tokenListCreator.analyze(analyzer.tokenStream("", text), includeAttributes, analyzer.getPositionIncrementGap(""), analyzer.getOffsetGap(""));
            }
            detailResponse = new AnalyzeAction.DetailAnalyzeResponse(new AnalyzeAction.AnalyzeTokenList(name, tokenListCreator.getArrayTokens()));
        }
        return detailResponse;
    }

    private static TokenStream createStackedTokenStream(String source, CharFilterFactory[] charFilterFactories, TokenizerFactory tokenizerFactory, TokenFilterFactory[] tokenFilterFactories, int current) {
        Reader reader = new StringReader(source);
        for (CharFilterFactory charFilterFactory : charFilterFactories) {
            reader = charFilterFactory.create(reader);
        }
        Tokenizer tokenizer = tokenizerFactory.create();
        tokenizer.setReader(reader);
        Tokenizer tokenStream = tokenizer;
        for (int i = 0; i < current; ++i) {
            tokenStream = tokenFilterFactories[i].create((TokenStream)tokenStream);
        }
        return tokenStream;
    }

    private static String writeCharStream(Reader input) {
        int len;
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to analyze (charFiltering)", (Throwable)e, new Object[0]);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        return sb.toString();
    }

    private static Map<String, Object> extractExtendedAttributes(TokenStream stream, Set<String> includeAttributes) {
        TreeMap<String, Object> extendedAttributes = new TreeMap<String, Object>();
        stream.reflectWith((attClass, key, value) -> {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (PositionIncrementAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (OffsetAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (TypeAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (includeAttributes == null || includeAttributes.isEmpty() || includeAttributes.contains(key.toLowerCase(Locale.ROOT))) {
                if (value instanceof BytesRef) {
                    BytesRef p = (BytesRef)value;
                    value = p.toString();
                }
                extendedAttributes.put(key, value);
            }
        });
        return extendedAttributes;
    }

    private static class TokenListCreator {
        int lastPosition = -1;
        int lastOffset = 0;
        List<AnalyzeAction.AnalyzeToken> tokens = new ArrayList<AnalyzeAction.AnalyzeToken>();
        private TokenCounter tc;

        TokenListCreator(int maxTokenCount) {
            this.tc = new TokenCounter(maxTokenCount);
        }

        private void analyze(TokenStream stream, Set<String> includeAttributes, int positionIncrementGap, int offsetGap) {
            try {
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                PositionLengthAttribute posLen = (PositionLengthAttribute)stream.addAttribute(PositionLengthAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        this.lastPosition += increment;
                    }
                    this.tokens.add(new AnalyzeAction.AnalyzeToken(term.toString(), this.lastPosition, this.lastOffset + offset.startOffset(), this.lastOffset + offset.endOffset(), posLen.getPositionLength(), type.type(), TransportAnalyzeAction.extractExtendedAttributes(stream, includeAttributes)));
                    this.tc.increment();
                }
                stream.end();
                this.lastOffset += offset.endOffset();
                this.lastPosition += posIncr.getPositionIncrement();
                this.lastPosition += positionIncrementGap;
                this.lastOffset += offsetGap;
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to analyze", (Throwable)e, new Object[0]);
            }
            finally {
                IOUtils.closeWhileHandlingException((Closeable)stream);
            }
        }

        private AnalyzeAction.AnalyzeToken[] getArrayTokens() {
            return this.tokens.toArray(new AnalyzeAction.AnalyzeToken[0]);
        }
    }

    private static class TokenCounter {
        private int tokenCount = 0;
        private int maxTokenCount;

        private TokenCounter(int maxTokenCount) {
            this.maxTokenCount = maxTokenCount;
        }

        private void increment() {
            ++this.tokenCount;
            if (this.tokenCount > this.maxTokenCount) {
                throw new IllegalStateException("The number of tokens produced by calling _analyze has exceeded the allowed maximum of [" + this.maxTokenCount + "]. This limit can be set by changing the [index.analyze.max_token_count] index level setting.");
            }
        }
    }
}

