/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.NodeProperties;
import org.openqa.selenium.bidi.script.RegExpValue;
import org.openqa.selenium.bidi.script.WindowProxyProperties;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class RemoteValue {
    private static final Json JSON = new Json();
    private final Type type;
    private final Optional<String> handle;
    private final Optional<Long> internalId;
    private final Optional<Object> value;
    private final Optional<String> sharedId;

    public RemoteValue(Type type, Optional<String> handle, Optional<Long> internalId, Optional<Object> value, Optional<String> sharedId) {
        this.type = type;
        this.handle = handle;
        this.internalId = internalId;
        this.value = value;
        this.sharedId = sharedId;
    }

    public static RemoteValue fromJson(JsonInput input) {
        Type type = null;
        Optional<String> handle = Optional.empty();
        Optional<Long> internalId = Optional.empty();
        Optional<Object> value = Optional.empty();
        Optional<String> sharedId = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    String typeString = (String)input.read(String.class);
                    type = Type.findByName(typeString);
                    continue block14;
                }
                case "handle": {
                    handle = Optional.ofNullable((String)input.read(String.class));
                    continue block14;
                }
                case "internalId": {
                    internalId = Optional.ofNullable((Long)input.read(Long.class));
                    continue block14;
                }
                case "value": {
                    value = Optional.ofNullable(input.read(Object.class));
                    continue block14;
                }
                case "sharedId": {
                    sharedId = Optional.ofNullable((String)input.read(String.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        if (value.isPresent()) {
            value = Optional.ofNullable(RemoteValue.deserializeValue(value.get(), type));
        }
        return new RemoteValue(type, handle, internalId, value, sharedId);
    }

    public String getType() {
        return this.type.toString();
    }

    public Optional<String> getHandle() {
        return this.handle;
    }

    public Optional<Long> getInternalId() {
        return this.internalId;
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public Optional<String> getSharedId() {
        return this.sharedId;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        toReturn.put("type", this.getType());
        this.handle.ifPresent(handleValue -> toReturn.put("handle", (String)handleValue));
        this.internalId.ifPresent(id -> toReturn.put("internalId", (String)id));
        this.value.ifPresent(actualValue -> toReturn.put("value", (String)actualValue));
        this.sharedId.ifPresent(id -> toReturn.put("sharedId", (String)id));
        return Collections.unmodifiableMap(toReturn);
    }

    private static Object deserializeValue(Object value, Type type) {
        Object finalValue;
        switch (type) {
            case ARRAY: 
            case NODE_LIST: 
            case SET: {
                try (StringReader reader = new StringReader(JSON.toJson((Object)value));
                     JsonInput input = JSON.newInput((Reader)reader);){
                    finalValue = input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                    break;
                }
            }
            case MAP: 
            case OBJECT: {
                List result = (List)((Object)value);
                HashMap map = new HashMap();
                for (List list : result) {
                    StringReader reader;
                    Object key = list.get(0);
                    if (!(key instanceof String)) {
                        reader = new StringReader(JSON.toJson(key));
                        try (JsonInput keyInput = JSON.newInput((Reader)reader);){
                            key = keyInput.read(RemoteValue.class);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    reader = new StringReader(JSON.toJson(list.get(1)));
                    try {
                        JsonInput valueInput = JSON.newInput((Reader)reader);
                        try {
                            RemoteValue value1 = (RemoteValue)valueInput.read(RemoteValue.class);
                            map.put(key, value1);
                        }
                        finally {
                            if (valueInput == null) continue;
                            valueInput.close();
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finalValue = map;
                break;
            }
            case REGULAR_EXPRESSION: {
                try (StringReader reader = new StringReader(JSON.toJson((Object)value));
                     JsonInput input = JSON.newInput((Reader)reader);){
                    finalValue = input.read(RegExpValue.class);
                    break;
                }
            }
            case WINDOW: {
                try (StringReader reader = new StringReader(JSON.toJson((Object)value));
                     JsonInput input = JSON.newInput((Reader)reader);){
                    finalValue = input.read(WindowProxyProperties.class);
                    break;
                }
            }
            case NODE: {
                try (StringReader reader = new StringReader(JSON.toJson((Object)value));
                     JsonInput input = JSON.newInput((Reader)reader);){
                    finalValue = input.read(NodeProperties.class);
                    break;
                }
            }
            default: {
                finalValue = value;
            }
        }
        return finalValue;
    }

    private static enum Type {
        UNDEFINED("undefined"),
        NULL("null"),
        STRING("string"),
        NUMBER("number"),
        SPECIAL_NUMBER("number"),
        BOOLEAN("boolean"),
        BIGINT("bigint"),
        ARRAY("array"),
        DATE("date"),
        MAP("map"),
        OBJECT("object"),
        REGULAR_EXPRESSION("regexp"),
        SET("set"),
        SYMBOL("symbol"),
        FUNCTION("function"),
        WEAK_MAP("weakmap"),
        WEAK_SET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPED_ARRAY("typedarray"),
        ARRAY_BUFFER("arraybuffer"),
        NODE_LIST("nodelist"),
        HTML_COLLECTION("htmlcollection"),
        NODE("node"),
        WINDOW("window");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type findByName(String name) {
            Type result = null;
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                result = type;
                break;
            }
            return result;
        }
    }
}

