/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.stream.io.util.AbstractDemarcator;

public class TextLineDemarcator
extends AbstractDemarcator {
    private static int CR = 13;
    private static int LF = 10;

    public TextLineDemarcator(InputStream is) {
        this(is, 8192);
    }

    public TextLineDemarcator(InputStream is, int initialBufferSize) {
        super(is, Integer.MAX_VALUE, initialBufferSize);
    }

    public OffsetInfo nextOffsetInfo() throws IOException {
        return this.nextOffsetInfo(null);
    }

    public OffsetInfo nextOffsetInfo(byte[] startsWith) throws IOException {
        OffsetInfo offsetInfo = null;
        int previousByteVal = 0;
        byte[] data = null;
        block0: while (data == null && this.availableBytesLength != -1) {
            int size;
            if (this.index >= this.availableBytesLength) {
                this.fill();
            }
            int delimiterSize = 0;
            if (this.availableBytesLength != -1) {
                int i;
                for (i = this.index; i < this.availableBytesLength; ++i) {
                    int byteVal = this.buffer[i];
                    if (byteVal == LF) {
                        delimiterSize = previousByteVal == CR ? 2 : 1;
                    } else if (previousByteVal == CR) {
                        delimiterSize = 1;
                        --i;
                    }
                    previousByteVal = byteVal;
                    if (delimiterSize <= 0) continue;
                    this.index = i + 1;
                    int size2 = Math.max(1, this.index - this.mark);
                    offsetInfo = new OffsetInfo(this.offset, size2, delimiterSize);
                    this.offset += (long)size2;
                    if (startsWith != null) {
                        data = this.extractDataToken(size2);
                    }
                    this.mark = this.index;
                    break block0;
                }
                this.index = i;
                continue;
            }
            int n = delimiterSize = previousByteVal == CR || previousByteVal == LF ? 1 : 0;
            if (offsetInfo == null && (size = this.index - this.mark) > 0) {
                offsetInfo = new OffsetInfo(this.offset, size, delimiterSize);
                this.offset += (long)size;
            }
            if (startsWith == null) continue;
            data = this.extractDataToken(this.index - this.mark);
        }
        if (startsWith != null && data != null) {
            if (startsWith.length > data.length) {
                offsetInfo.setStartsWithMatch(false);
            } else {
                for (int i = 0; i < startsWith.length; ++i) {
                    byte sB = startsWith[i];
                    if (sB == data[i]) continue;
                    offsetInfo.setStartsWithMatch(false);
                    break;
                }
            }
        }
        return offsetInfo;
    }

    public static class OffsetInfo {
        private final long startOffset;
        private final long length;
        private final int crlfLength;
        private boolean startsWithMatch = true;

        private OffsetInfo(long startOffset, long length, int crlfLength) {
            this.startOffset = startOffset;
            this.length = length;
            this.crlfLength = crlfLength;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getLength() {
            return this.length;
        }

        public int getCrlfLength() {
            return this.crlfLength;
        }

        public boolean isStartsWithMatch() {
            return this.startsWithMatch;
        }

        void setStartsWithMatch(boolean startsWithMatch) {
            this.startsWithMatch = startsWithMatch;
        }

        public String toString() {
            return "offset:" + this.startOffset + "; length:" + this.length + "; crlfLength:" + this.crlfLength;
        }
    }
}

