/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.database.mysql.MySQLDatabaseType;
import org.flywaydb.database.mysql.mariadb.MariaDBDatabaseType;
import org.flywaydb.database.postgresql.PostgreSQLDatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CustomFlywayConfiguration
implements FlywayConfigurationCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFlywayConfiguration.class);
    private static final String LOCATION_COMMON = "classpath:db/migration/common";
    private static final String LOCATION_DEFAULT = "classpath:db/migration/default";
    private static final String[] LOCATIONS_DEFAULT = new String[]{"classpath:db/migration/common", "classpath:db/migration/default"};
    private static final String LOCATION_MYSQL = "classpath:db/migration/mysql";
    private static final String[] LOCATIONS_MYSQL = new String[]{"classpath:db/migration/common", "classpath:db/migration/mysql"};
    private static final String LOCATION_POSTGRES = "classpath:db/migration/postgres";
    private static final String[] LOCATIONS_POSTGRES = new String[]{"classpath:db/migration/common", "classpath:db/migration/postgres"};
    private static final String LEGACY_FLYWAY_SCHEMA_TABLE = "schema_version";

    public void customize(FluentConfiguration configuration) {
        DatabaseType databaseType = this.getDatabaseType(configuration.getDataSource(), (org.flywaydb.core.api.configuration.Configuration)configuration);
        LOGGER.info("Determined database type is {}", (Object)databaseType.getName());
        if (databaseType instanceof MySQLDatabaseType || databaseType instanceof MariaDBDatabaseType) {
            LOGGER.info("Setting migration locations to {}", Arrays.asList(LOCATIONS_MYSQL));
            configuration.locations(LOCATIONS_MYSQL);
        } else if (databaseType instanceof PostgreSQLDatabaseType) {
            LOGGER.info("Setting migration locations to {}", Arrays.asList(LOCATIONS_POSTGRES));
            configuration.locations(LOCATIONS_POSTGRES);
        } else {
            LOGGER.info("Setting migration locations to {}", Arrays.asList(LOCATIONS_DEFAULT));
            configuration.locations(LOCATIONS_DEFAULT);
        }
        if (this.isLegacyFlywaySchemaTable(configuration.getDataSource())) {
            LOGGER.info("Using legacy Flyway configuration table - {}", (Object)LEGACY_FLYWAY_SCHEMA_TABLE);
            configuration.table(LEGACY_FLYWAY_SCHEMA_TABLE);
        } else {
            LOGGER.info("Using default Flyway configuration table");
        }
    }

    private DatabaseType getDatabaseType(DataSource dataSource, org.flywaydb.core.api.configuration.Configuration configuration) {
        DatabaseType databaseType;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection((Connection)connection, (org.flywaydb.core.api.configuration.Configuration)configuration);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new FlywayException("Unable to obtain connection from Flyway DataSource", (Throwable)e);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLegacyFlywaySchemaTable(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData((Connection)connection);
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);){
                while (resultSet.next()) {
                    String table = resultSet.getString(3);
                    LOGGER.trace("Found table {}", (Object)table);
                    if (!LEGACY_FLYWAY_SCHEMA_TABLE.equals(table)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FlywayException("Unable to obtain connection from Flyway DataSource", (Throwable)e);
        }
    }
}

