/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DeployerUtils {
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);

    private DeployerUtils() {
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuilder v = new StringBuilder();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        DeployerUtils.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    DeployerUtils.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                DeployerUtils.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuilder result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

