/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicMediaRangesHeader;

@Header(value="Accept")
public class Accept
extends BasicMediaRangesHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Accept";
    private static final Cache<String, Accept> CACHE = Cache.of(String.class, Accept.class).build();
    public static final Accept APPLICATION_ATOM_XML = Accept.of("application/atom+xml");
    public static final Accept APPLICATION_FORM_URLENCODED = Accept.of("application/x-www-form-urlencoded");
    public static final Accept APPLICATION_JSON = Accept.of("application/json");
    public static final Accept APPLICATION_OCTET_STREAM = Accept.of("application/octet-stream");
    public static final Accept APPLICATION_SOAP_XML = Accept.of("application/soap+xml");
    public static final Accept APPLICATION_SVG_XML = Accept.of("application/svg+xml");
    public static final Accept APPLICATION_XHTML_XML = Accept.of("application/xhtml+xml");
    public static final Accept APPLICATION_XML = Accept.of("application/xml");
    public static final Accept IMAGE_BMP = Accept.of("image/bmp");
    public static final Accept IMAGE_GIF = Accept.of("image/gif");
    public static final Accept IMAGE_JPEG = Accept.of("image/jpeg");
    public static final Accept IMAGE_PNG = Accept.of("image/png");
    public static final Accept IMAGE_SVG = Accept.of("image/svg+xml");
    public static final Accept IMAGE_TIFF = Accept.of("image/tiff");
    public static final Accept IMAGE_WEBP = Accept.of("image/webp");
    public static final Accept MULTIPART_FORM_DATA = Accept.of("multipart/form-data");
    public static final Accept TEXT_HTML = Accept.of("text/html");
    public static final Accept TEXT_PLAIN = Accept.of("text/plain");
    public static final Accept TEXT_XML = Accept.of("text/xml");
    public static final Accept WILDCARD = Accept.of("*/*");
    public static final Accept NULL = new Accept((String)null);

    public static Accept of(MediaRanges value) {
        return value == null ? null : new Accept(value);
    }

    public static Accept of(MediaType value) {
        return value == null ? null : new Accept(value.toString());
    }

    public static Accept of(String value) {
        return value == null ? null : CACHE.get(value, () -> new Accept(value));
    }

    public static Accept of(Supplier<MediaRanges> value) {
        return value == null ? null : new Accept(value);
    }

    public Accept(MediaRanges value) {
        super(NAME, value);
    }

    public Accept(String value) {
        super(NAME, value);
    }

    public Accept(Supplier<MediaRanges> value) {
        super(NAME, value);
    }
}

