/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.AssertionPredicates;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentBeanListAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentArrayAssertion<E, R>
extends FluentObjectAssertion<E[], R> {
    private static final Messages MESSAGES = Messages.of(FluentArrayAssertion.class, "Messages");
    private static final String MSG_arrayWasNotEmpty = MESSAGES.getString("arrayWasNotEmpty");
    private static final String MSG_arrayWasEmpty = MESSAGES.getString("arrayWasEmpty");
    private static final String MSG_arrayUnexpectedSize = MESSAGES.getString("arrayUnexpectedSize");
    private static final String MSG_arrayDidNotContainExpectedValue = MESSAGES.getString("arrayDidNotContainExpectedValue");
    private static final String MSG_arrayContainedUnexpectedValue = MESSAGES.getString("arrayContainedUnexpectedValue");
    private static final String MSG_arrayDidNotContainExpectedValueAt = MESSAGES.getString("arrayDidNotContainExpectedValueAt");
    private static final String MSG_arrayDidntContainAnyMatchingValue = MESSAGES.getString("arrayDidntContainAnyMatchingValue");
    private static final String MSG_arrayContainedNonMatchingValueAt = MESSAGES.getString("arrayContainedNonMatchingValueAt");

    public FluentArrayAssertion(Assertion creator, E[] value, R returns) {
        super(creator, value, returns);
    }

    public FluentArrayAssertion(E[] value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentBeanListAssertion<E, R> asBeanList() {
        return new FluentBeanListAssertion((Assertion)this, this.toList(), this.returns());
    }

    public FluentStringAssertion<R> asCdl() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : StringUtils.join((Object[])this.value(), ','), this.returns());
    }

    public FluentStringAssertion<R> asCdl(Function<E, String> function) {
        List<String> l = this.valueIsNull() ? null : CollectionUtils.stream((Object[])this.value()).map(function::apply).toList();
        return new FluentStringAssertion((Assertion)this, StringUtils.join(l, ','), this.returns());
    }

    public FluentAnyAssertion<E, R> asItem(int index) {
        return new FluentAnyAssertion(this, this.at(index), this.returns());
    }

    public FluentListAssertion<E, R> asSorted() {
        return new FluentListAssertion((Assertion)this, this.toSortedList(null), this.returns());
    }

    public FluentListAssertion<E, R> asSorted(Comparator<E> comparator) {
        return new FluentListAssertion((Assertion)this, this.toSortedList(comparator), this.returns());
    }

    @Override
    public FluentStringAssertion<R> asString() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : Utils.r(this.value()), this.returns());
    }

    public FluentStringListAssertion<R> asStrings() {
        return new FluentStringListAssertion((Assertion)this, this.valueIsNull() ? null : CollectionUtils.stream((Object[])this.value()).map((? super T o) -> Utils.s(o)).toList(), this.returns());
    }

    public FluentStringListAssertion<R> asStrings(Function<E, String> function) {
        List<String> l = this.valueIsNull() ? null : CollectionUtils.stream((Object[])this.value()).map(function::apply).toList();
        return new FluentStringListAssertion((Assertion)this, l, this.returns());
    }

    @Override
    public FluentArrayAssertion<E, R> asTransformed(Function<E[], E[]> function) {
        return new FluentArrayAssertion((Assertion)this, function.apply(this.orElse(null)), this.returns());
    }

    @Override
    @SafeVarargs
    public final R is(Predicate<E> ... tests) throws AssertionError {
        this.isSize(tests.length);
        int j = this.length();
        for (int i = 0; i < j; ++i) {
            Predicate<E> t = tests[i];
            if (!Utils.nn(t) || t.test(this.at(i))) continue;
            throw this.error(MSG_arrayDidNotContainExpectedValueAt, i, this.getFailureMessage(t, this.at(i)));
        }
        return this.returns();
    }

    public R isAll(Predicate<E> test) throws AssertionError {
        AssertionUtils.assertArgNotNull("test", test);
        int j = this.length();
        for (int i = 0; i < j; ++i) {
            if (test.test(this.at(i))) continue;
            throw this.error(MSG_arrayContainedNonMatchingValueAt, i, this.getFailureMessage(test, this.at(i)));
        }
        return this.returns();
    }

    public R isAny(Predicate<E> test) throws AssertionError {
        AssertionUtils.assertArgNotNull("test", test);
        for (Object v : (Object[])this.value()) {
            if (!test.test(v)) continue;
            return this.returns();
        }
        throw this.error(MSG_arrayDidntContainAnyMatchingValue, Utils.r(this.value()));
    }

    public R isContains(E entry) throws AssertionError {
        int j = this.length();
        for (int i = 0; i < j; ++i) {
            if (!Utils.eq(this.at(i), entry)) continue;
            return this.returns();
        }
        throw this.error(MSG_arrayDidNotContainExpectedValue, Utils.r(entry), Utils.r(this.value()));
    }

    public R isEmpty() throws AssertionError {
        if (this.length() != 0) {
            throw this.error(MSG_arrayWasNotEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isHas(E ... entries) throws AssertionError {
        AssertionUtils.assertArgNotNull("entries", entries);
        Predicate[] p = (Predicate[])CollectionUtils.stream(entries).map(AssertionPredicates::eq).toArray(Predicate[]::new);
        return this.is(p);
    }

    public R isNotContains(E entry) throws AssertionError {
        int j = this.length();
        for (int i = 0; i < j; ++i) {
            if (!Utils.eq(this.at(i), entry)) continue;
            throw this.error(MSG_arrayContainedUnexpectedValue, Utils.r(entry), Utils.r(this.value()));
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        if (this.length() == 0) {
            throw this.error(MSG_arrayWasEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        if (this.length() != size) {
            throw this.error(MSG_arrayUnexpectedSize, size, this.length());
        }
        return this.returns();
    }

    @Override
    public FluentArrayAssertion<E, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentArrayAssertion<E, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentArrayAssertion<E, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentArrayAssertion<E, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentArrayAssertion<E, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    @Override
    public String toString() {
        return this.valueIsNull() ? null : Arrays.toString((Object[])this.value());
    }

    private E at(int index) {
        return (E)(this.valueIsNull() || index >= this.length() || index < 0 ? null : ((Object[])this.value())[index]);
    }

    private int length() {
        return ((Object[])this.value()).length;
    }

    private List<E> toList() {
        return this.valueIsNull() ? null : CollectionUtils.list((Object[])this.value());
    }

    private List<E> toSortedList(Comparator<E> comparator) {
        return this.valueIsNull() ? null : CollectionUtils.sortedList(comparator, (Object[])this.value());
    }
}

