/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.juneau.commons.io.ReaderInputStream;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;

public class ReaderEntity
extends BasicHttpEntity {
    private byte[] byteCache;
    private String stringCache;

    public ReaderEntity() {
    }

    public ReaderEntity(ContentType contentType, Reader content) {
        super(contentType, content);
    }

    protected ReaderEntity(ReaderEntity copyFrom) {
        super(copyFrom);
    }

    @Override
    public byte[] asBytes() throws IOException {
        if (this.isCached() && this.byteCache == null) {
            this.byteCache = IoUtils.readBytes((Reader)this.content());
        }
        if (Utils.nn((Object)this.byteCache)) {
            return this.byteCache;
        }
        return IoUtils.readBytes((Reader)this.content());
    }

    @Override
    public String asString() throws IOException {
        if (this.isCached() && this.stringCache == null) {
            this.stringCache = IoUtils.read((Reader)this.content(), (long)this.getMaxLength());
        }
        if (Utils.nn((Object)this.stringCache)) {
            return this.stringCache;
        }
        return IoUtils.read((Reader)this.content());
    }

    @Override
    public ReaderEntity copy() {
        return new ReaderEntity(this);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.isCached()) {
            return new ByteArrayInputStream(this.asBytes());
        }
        return new ReaderInputStream(this.content(), this.getCharset());
    }

    @Override
    public long getContentLength() {
        if (this.isCached()) {
            return this.asSafeBytes().length;
        }
        return super.getContentLength();
    }

    @Override
    public boolean isRepeatable() {
        return this.isCached();
    }

    @Override
    public boolean isStreaming() {
        return !this.isCached();
    }

    @Override
    public ReaderEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public ReaderEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public ReaderEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public ReaderEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public ReaderEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public ReaderEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public ReaderEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public ReaderEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public ReaderEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public ReaderEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public ReaderEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public ReaderEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    @Override
    public ReaderEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        AssertionUtils.assertArgNotNull((String)"out", (Object)out);
        if (this.isCached()) {
            out.write(this.asBytes());
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(out, this.getCharset());
            IoUtils.pipe((Reader)this.content(), (Writer)osw);
            osw.flush();
        }
        out.flush();
    }

    private Reader content() {
        return Objects.requireNonNull(this.contentOrElse(null), "Reader is null.");
    }
}

