/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterUnfold
extends QueryIterRepeatApply {
    protected final Expr expr;
    protected final Var var1;
    protected final Var var2;

    public QueryIterUnfold(QueryIterator qIter, Expr expr, Var var1, Var var2, ExecutionContext execCxt) {
        super(qIter, execCxt);
        this.expr = expr;
        this.var1 = var1;
        this.var2 = var2;
    }

    @Override
    protected QueryIterator nextStage(Binding inputBinding) {
        NodeValue nv;
        try {
            nv = this.expr.eval(inputBinding, this.getExecContext());
        }
        catch (ExprEvalException ex) {
            return QueryIterSingleton.create(inputBinding, this.getExecContext());
        }
        Node n = nv.asNode();
        if (n.isLiteral()) {
            String dtURI = n.getLiteralDatatypeURI();
            if ("http://w3id.org/awslabs/neptune/SPARQL-CDTs/List".equals(dtURI)) {
                return this.unfoldList(n.getLiteral(), inputBinding);
            }
            if ("http://w3id.org/awslabs/neptune/SPARQL-CDTs/Map".equals(dtURI)) {
                return this.unfoldMap(n.getLiteral(), inputBinding);
            }
        }
        return QueryIterSingleton.create(inputBinding, this.getExecContext());
    }

    protected QueryIterator unfoldList(LiteralLabel lit, Binding inputBinding) {
        List<CDTValue> itListElmts = CompositeDatatypeList.getValue(lit);
        return new QueryIterUnfoldWorkerForLists(inputBinding, (Iterable<CDTValue>)itListElmts);
    }

    protected QueryIterator unfoldMap(LiteralLabel lit, Binding inputBinding) {
        Set<Map.Entry<CDTKey, CDTValue>> itMapEntries = CompositeDatatypeMap.getValue(lit).entrySet();
        return new QueryIterUnfoldWorkerForMaps(inputBinding, (Iterable<Map.Entry<CDTKey, CDTValue>>)itMapEntries);
    }

    protected class QueryIterUnfoldWorkerForLists
    extends QueryIterUnfoldWorkerBase<CDTValue> {
        protected int nextIndex;

        public QueryIterUnfoldWorkerForLists(Binding inputBinding, Iterator<CDTValue> itListElmts) {
            super(inputBinding, itListElmts);
            this.nextIndex = 0;
        }

        public QueryIterUnfoldWorkerForLists(Binding inputBinding, Iterable<CDTValue> itListElmts) {
            super(inputBinding, itListElmts);
            this.nextIndex = 0;
        }

        @Override
        public void output(IndentedWriter out, SerializationContext sCxt) {
            out.write("QueryIterUnfoldWorkerForLists");
        }

        @Override
        protected Binding moveToNextBinding() {
            Node indexNode;
            CDTValue nextElmt = (CDTValue)this.itElmts.next();
            ++this.nextIndex;
            if (QueryIterUnfold.this.var2 != null) {
                String indexStr = Integer.toString(this.nextIndex);
                indexNode = NodeFactory.createLiteralDT(indexStr, XSDDatatype.XSDinteger);
            } else {
                indexNode = null;
            }
            if (nextElmt.isNull()) {
                if (QueryIterUnfold.this.var2 != null) {
                    return BindingFactory.binding(this.inputBinding, QueryIterUnfold.this.var2, indexNode);
                }
                return this.inputBinding;
            }
            if (nextElmt.isNode()) {
                Node elmtNode = nextElmt.asNode();
                if (QueryIterUnfold.this.var2 != null) {
                    return BindingFactory.binding(this.inputBinding, QueryIterUnfold.this.var1, elmtNode, QueryIterUnfold.this.var2, indexNode);
                }
                return BindingFactory.binding(this.inputBinding, QueryIterUnfold.this.var1, elmtNode);
            }
            throw new UnsupportedOperationException("unexpected list element: " + nextElmt.getClass().getName());
        }
    }

    protected class QueryIterUnfoldWorkerForMaps
    extends QueryIterUnfoldWorkerBase<Map.Entry<CDTKey, CDTValue>> {
        public QueryIterUnfoldWorkerForMaps(Binding inputBinding, Iterator<Map.Entry<CDTKey, CDTValue>> itMapElmts) {
            super(inputBinding, itMapElmts);
        }

        public QueryIterUnfoldWorkerForMaps(Binding inputBinding, Iterable<Map.Entry<CDTKey, CDTValue>> itMapElmts) {
            super(inputBinding, itMapElmts);
        }

        @Override
        public void output(IndentedWriter out, SerializationContext sCxt) {
            out.write("QueryIterUnfoldWorkerForMaps");
        }

        @Override
        protected Binding moveToNextBinding() {
            Map.Entry elmt = (Map.Entry)this.itElmts.next();
            CDTKey key = (CDTKey)elmt.getKey();
            CDTValue value = (CDTValue)elmt.getValue();
            Node keyNode = key.asNode();
            if (value.isNull() || QueryIterUnfold.this.var2 == null) {
                return BindingFactory.binding(this.inputBinding, QueryIterUnfold.this.var1, keyNode);
            }
            if (value.isNode()) {
                Node valueNode = value.asNode();
                return BindingFactory.binding(this.inputBinding, QueryIterUnfold.this.var1, keyNode, QueryIterUnfold.this.var2, valueNode);
            }
            throw new UnsupportedOperationException("unexpected map value: " + value.getClass().getName());
        }
    }

    protected static class MapElementExtractor
    extends ElementExtractorBase<Map.Entry<String, String>> {
        public MapElementExtractor(String mapAsString) {
            super(mapAsString);
        }

        @Override
        public Map.Entry<String, String> produceNext() {
            this.consumeWhiteSpace();
            if (this.cursor >= this.str.length()) {
                return null;
            }
            int nextKeyBegin = this.cursor;
            this.advanceToNextColon();
            final String nextKey = this.str.substring(nextKeyBegin, this.cursor).strip();
            ++this.cursor;
            this.consumeWhiteSpace();
            int nextValueBegin = this.cursor;
            if (this.str.charAt(this.cursor) == '[') {
                this.advanceToEndOfSubList();
            } else if (this.str.charAt(this.cursor) == '{') {
                this.advanceToEndOfSubMap();
            }
            this.advanceToNextCommaOrEnd();
            final String nextValue = this.str.substring(nextValueBegin, this.cursor).strip();
            ++this.cursor;
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return nextKey;
                }

                @Override
                public String getValue() {
                    return nextValue;
                }

                @Override
                public String setValue(String v) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected void advanceToNextColon() {
            while (this.cursor < this.str.length() && this.str.charAt(this.cursor) != ':') {
                ++this.cursor;
            }
        }
    }

    protected static class ListElementExtractor
    extends ElementExtractorBase<String> {
        public ListElementExtractor(String listAsString) {
            super(listAsString);
        }

        @Override
        public String produceNext() {
            this.consumeWhiteSpace();
            if (this.cursor >= this.str.length()) {
                return null;
            }
            int nextElmtBegin = this.cursor;
            if (this.str.charAt(this.cursor) == '[') {
                this.advanceToEndOfSubList();
            } else if (this.str.charAt(this.cursor) == '{') {
                this.advanceToEndOfSubMap();
            }
            this.advanceToNextCommaOrEnd();
            String nextElmt = this.str.substring(nextElmtBegin, this.cursor).strip();
            ++this.cursor;
            return nextElmt;
        }
    }

    protected static abstract class ElementExtractorBase<T>
    implements Iterator<T> {
        protected final String str;
        protected int cursor = 0;
        private T nextElmt = null;

        protected ElementExtractorBase(String str2) {
            this.str = str2.strip();
        }

        @Override
        public boolean hasNext() {
            if (this.nextElmt != null) {
                return true;
            }
            this.nextElmt = this.produceNext();
            return this.nextElmt != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T r = this.nextElmt;
            this.nextElmt = null;
            return r;
        }

        protected abstract T produceNext();

        protected void consumeWhiteSpace() {
            while (this.cursor < this.str.length() && this.str.charAt(this.cursor) == ' ') {
                ++this.cursor;
            }
        }

        protected void advanceToEndOfSubList() {
            while (this.cursor < this.str.length() && this.str.charAt(this.cursor) != ']') {
                ++this.cursor;
                if (this.str.charAt(this.cursor) == '[') {
                    this.advanceToEndOfSubList();
                    ++this.cursor;
                    continue;
                }
                if (this.str.charAt(this.cursor) != '{') continue;
                this.advanceToEndOfSubMap();
                ++this.cursor;
            }
        }

        protected void advanceToEndOfSubMap() {
            while (this.cursor < this.str.length() && this.str.charAt(this.cursor) != '}') {
                ++this.cursor;
                if (this.str.charAt(this.cursor) == '[') {
                    this.advanceToEndOfSubList();
                    ++this.cursor;
                    continue;
                }
                if (this.str.charAt(this.cursor) != '{') continue;
                this.advanceToEndOfSubMap();
                ++this.cursor;
            }
        }

        protected void advanceToNextCommaOrEnd() {
            while (this.cursor < this.str.length() && this.str.charAt(this.cursor) != ',') {
                ++this.cursor;
            }
        }
    }

    protected abstract class QueryIterUnfoldWorkerBase<T>
    extends QueryIteratorBase {
        protected final Binding inputBinding;
        protected final Iterator<T> itElmts;

        protected QueryIterUnfoldWorkerBase(Binding inputBinding, Iterator<T> itElmts) {
            this.inputBinding = inputBinding;
            this.itElmts = itElmts;
        }

        protected QueryIterUnfoldWorkerBase(Binding inputBinding, Iterable<T> itElmts) {
            this(inputBinding, itElmts.iterator());
        }

        @Override
        protected boolean hasNextBinding() {
            return this.itElmts.hasNext();
        }

        @Override
        protected void requestCancel() {
        }

        @Override
        protected void closeIterator() {
        }
    }
}

