/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LangBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.graph.NodeConst;

public abstract class LangTurtleBase
extends LangBase {
    protected static final String KW_A = "a";
    protected static final String KW_SAME_AS = "=";
    protected static final String KW_TRUE = "true";
    protected static final String KW_FALSE = "false";
    protected static final boolean VERBOSE = false;
    private Node currentGraph = null;
    protected final PrefixMap prefixMap;
    protected static final Node nodeSameAs = NodeConst.nodeOwlSameAs;
    protected static final Node nodeLogImplies = NodeFactory.createURI("http://www.w3.org/2000/10/swap/log#implies");

    protected final Node getCurrentGraph() {
        return this.currentGraph;
    }

    protected final void setCurrentGraph(Node graph) {
        this.currentGraph = graph;
    }

    protected LangTurtleBase(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
        this.prefixMap = profile.getPrefixMap();
    }

    @Override
    protected final void runParser() {
        while (this.moreTokens()) {
            String text;
            Token t = this.peekToken();
            if (this.lookingAt(TokenType.DIRECTIVE)) {
                this.directiveAtWord();
                continue;
            }
            if (this.lookingAt(TokenType.KEYWORD) && ((text = t.getImage()).equalsIgnoreCase("PREFIX") || text.equalsIgnoreCase("BASE") || text.equalsIgnoreCase("VERSION"))) {
                this.directiveKeyword();
                continue;
            }
            this.oneTopLevelElement();
            if (!this.lookingAt(TokenType.EOF)) continue;
            break;
        }
    }

    protected abstract void oneTopLevelElement();

    protected abstract void emit(Node var1, Node var2, Node var3);

    protected final void directiveKeyword() {
        Token t = this.peekToken();
        String x = t.getImage();
        this.nextToken();
        if (x.equalsIgnoreCase("BASE")) {
            this.directiveBase();
            return;
        }
        if (x.equalsIgnoreCase("PREFIX")) {
            this.directivePrefix();
            return;
        }
        if (x.equalsIgnoreCase("VERSION")) {
            this.directiveVersion();
            return;
        }
        this.exception(t, "Unrecognized keyword for directive: %s", x);
    }

    protected final void directiveAtWord() {
        Token t = this.peekToken();
        String x = t.getImage();
        this.nextToken();
        this.processAtDirective(t, x);
    }

    private void processAtDirective(Token t, String x) {
        if (x.equals("base")) {
            this.directiveBase();
            if (this.isStrictMode()) {
                this.expect("Base directive not terminated by a dot", TokenType.DOT);
            } else {
                this.skipIf(TokenType.DOT);
            }
            return;
        }
        if (x.equals("prefix")) {
            this.directivePrefix();
            if (this.isStrictMode()) {
                this.expect("Prefix directive not terminated by a dot", TokenType.DOT);
            } else {
                this.skipIf(TokenType.DOT);
            }
            return;
        }
        if (x.equals("version")) {
            this.directiveVersion();
            if (this.isStrictMode()) {
                this.expect("Prefix directive not terminated by a dot", TokenType.DOT);
            } else {
                this.skipIf(TokenType.DOT);
            }
            return;
        }
        this.exception(t, "Unrecognized directive: %s", x);
    }

    protected final void directivePrefix() {
        if (!this.lookingAt(TokenType.PREFIXED_NAME)) {
            this.exception(this.peekToken(), "PREFIX or @prefix requires a prefix (found '" + String.valueOf(this.peekToken()) + "')", new Object[0]);
        }
        if (this.peekToken().getImage2().length() != 0) {
            this.exception(this.peekToken(), "PREFIX or @prefix requires a prefix with no suffix (found '" + String.valueOf(this.peekToken()) + "')", new Object[0]);
        }
        String prefix = this.peekToken().getImage();
        this.nextToken();
        if (!this.lookingAt(TokenType.IRI)) {
            this.exception(this.peekToken(), "@prefix requires an IRI (found '" + String.valueOf(this.peekToken()) + "')", new Object[0]);
        }
        String str2 = this.peekToken().getImage();
        String iri2 = this.profile.resolveIRI(str2, this.currLine, this.currCol);
        this.prefixMap.add(prefix, iri2);
        this.emitPrefix(prefix, iri2);
        this.nextToken();
    }

    protected final void directiveBase() {
        Token token = this.peekToken();
        if (!this.lookingAt(TokenType.IRI)) {
            this.exception(token, "BASE or @base requires an IRI (found '" + String.valueOf(token) + "')", new Object[0]);
        }
        String str2 = token.getImage();
        String baseIRI = this.profile.resolveIRI(str2, this.currLine, this.currCol);
        this.profile.setBaseIRI(baseIRI);
        this.emitBase(baseIRI);
        this.nextToken();
    }

    protected final void directiveVersion() {
        Token token = this.peekToken();
        String directive = null;
        if (token.hasType(TokenType.LITERAL_LANG)) {
            Token subToken = token.getSubToken1();
            directive = token.getImage2();
            token = subToken;
        }
        if (!token.isString()) {
            this.exception(token, "Version must be a string (found '" + String.valueOf(token) + "')", new Object[0]);
        }
        StringType stringType = token.getStringType();
        switch (stringType) {
            case STRING1: 
            case STRING2: {
                break;
            }
            case LONG_STRING1: 
            case LONG_STRING2: {
                this.exception(token, "Triple-quoted strings not allowed for the version string (found '" + String.valueOf(token) + "')", new Object[0]);
                break;
            }
            default: {
                this.exception(token, "Expected a quoted string for the version setting (found '" + String.valueOf(token) + "')", new Object[0]);
            }
        }
        String versionStr = token.getImage();
        this.emitVersion(versionStr);
        this.nextToken();
        if (directive != null) {
            this.processAtDirective(token, directive);
        }
    }

    protected final void triples() {
        if (this.lookingAt(TokenType.NODE)) {
            this.triplesSameSubject();
            return;
        }
        boolean maybeList = this.lookingAt(TokenType.LPAREN);
        if (this.peekTriplesNodeCompound()) {
            Node n = this.triplesNodeCompound();
            if (this.isStrictMode() && maybeList) {
                if (this.peekPredicate()) {
                    this.predicateObjectList(n);
                    this.expectEndOfTriples();
                    return;
                }
                this.exception(this.peekToken(), "Predicate/object required after (...) - Unexpected token : %s", this.peekToken());
            }
            if (this.lookingAt(TokenType.EOF)) {
                return;
            }
            if (this.lookingAt(TokenType.DOT)) {
                this.nextToken();
                return;
            }
            if (this.peekPredicate()) {
                this.predicateObjectList(n);
            }
            this.expectEndOfTriples();
            return;
        }
        if (this.lookingAt(TokenType.LT2)) {
            Node subject = this.parseReifiedTriple();
            if (this.lookingAt(TokenType.DOT)) {
                this.nextToken();
                return;
            }
            this.predicateObjectList(subject);
            this.expectEndOfTriples();
            return;
        }
        if (this.lookingAt(TokenType.L_TRIPLE)) {
            Node subject = this.parseTripleTerm();
            return;
        }
        this.exception(this.peekToken(), "Out of place: %s", this.peekToken());
    }

    private Node parseReifiedTriple() {
        Token startToken = this.nextToken();
        long startLine = startToken.getLine();
        long startColumn = startToken.getColumn();
        Node s = this.rtSubject(startToken);
        Node p = this.predicate();
        Node o = this.rtObject(startToken);
        Node reif = this.possibleReifier(s, p, o, startLine, startColumn);
        if (!this.lookingAt(TokenType.GT2)) {
            this.exception(this.peekToken(), "Expected >>, found %s", this.peekToken().text());
        }
        this.nextToken();
        Node tripleTerm = this.profile.createTripleTerm(s, p, o, startLine, startColumn);
        this.emitTriple(reif, NodeConst.nodeReifies, tripleTerm);
        return reif;
    }

    private Node rtSubject(Token startToken) {
        if (this.lookingAt(TokenType.LT2)) {
            return this.parseReifiedTriple();
        }
        Node s = this.possibleAnon();
        if (s != null) {
            return s;
        }
        s = this.node();
        if (!s.isURI() && !s.isBlank()) {
            this.exception(this.peekToken(), "Subject in a reified triple is not a URI, blank node or a nested reified triple: %s", s);
        }
        return s;
    }

    private Node rtObject(Token startToken) {
        if (this.lookingAt(TokenType.LT2)) {
            return this.parseReifiedTriple();
        }
        Node o = this.possibleAnon();
        if (o != null) {
            return o;
        }
        o = this.object();
        if (!(o.isURI() || o.isBlank() || o.isLiteral() || o.isTripleTerm())) {
            this.exception(startToken, "Illgeal object in a reified triple: %s", o);
        }
        return o;
    }

    private Node possibleAnon() {
        if (!this.lookingAt(TokenType.LBRACKET)) {
            return null;
        }
        this.nextToken();
        if (!this.lookingAt(TokenType.RBRACKET)) {
            this.exception(this.peekToken(), "Found '[' in reified triple. It must be followed by ']' but got: " + String.valueOf(this.peekToken()), new Object[0]);
        }
        Token token = this.nextToken();
        Node x = this.profile.createBlankNode(this.currentGraph, token.getLine(), token.getColumn());
        return x;
    }

    private Node parseTripleTerm() {
        Token entryToken = this.nextToken();
        Node s = this.ttSubject();
        if (s.isTripleTerm()) {
            this.exception(entryToken, "Subject of a triple term is a triple term", new Object[0]);
        }
        Node p = this.predicate();
        Node o = this.ttObject();
        if (!this.lookingAt(TokenType.R_TRIPLE)) {
            this.exception(this.peekToken(), "Expected )>>, found %s", this.peekToken().text());
        }
        this.nextToken();
        return this.profile.createTripleTerm(s, p, o, entryToken.getLine(), entryToken.getColumn());
    }

    protected Node possibleReifier(Node s, Node p, Node o, long line, long column) {
        if (this.lookingAt(TokenType.VBAR)) {
            this.exception(this.peekToken(), "Bad syntax: reifiers are '~', not '|'", new Object[0]);
        }
        if (!this.lookingAt(TokenType.TILDE)) {
            return this.profile.createBlankNode(this.currentGraph, line, column);
        }
        return this.Reifier(s, p, o, line, column);
    }

    protected Node Reifier(Node s, Node p, Node o, long line, long column) {
        Node reif;
        Token tildeToken = this.nextToken();
        Token tokenReif = this.peekToken();
        if (this.lookingAt(TokenType.LITERAL_DT) || this.lookingAt(TokenType.LITERAL_LANG)) {
            this.nextToken();
            this.exception(tildeToken, "Reifiers are URIs or blank nodes: found %s", tokenReif);
        }
        if (this.lookingAtIRIorBNode()) {
            this.nextToken();
            reif = this.tokenAsNode(tokenReif);
        } else if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            Token t = this.peekToken();
            if (!this.lookingAt(TokenType.RBRACKET)) {
                this.exception(this.peekToken(), "Bad %s in RDF triple. Expected ] after [", "riefier", this.peekToken().text());
            }
            this.nextToken();
            reif = this.profile.createBlankNode(this.currentGraph, t.getLine(), t.getColumn());
        } else {
            reif = this.profile.createBlankNode(this.currentGraph, tildeToken.getLine(), tildeToken.getColumn());
        }
        return reif;
    }

    private Node ttSubject() {
        Node node = this.term("subject");
        if (node.isLiteral()) {
            this.exception(this.peekToken(), "Literals are not legal in the subject position.", new Object[0]);
        }
        if (node.isTripleTerm()) {
            this.exception(this.peekToken(), "Triple terms are not legal in the subject position.", new Object[0]);
        }
        return node;
    }

    private Node ttObject() {
        Node node = this.term("object");
        return node;
    }

    private Node subject() {
        return this.nodeTerm();
    }

    private Node object() {
        return this.nodeTerm();
    }

    private Node nodeTerm() {
        if (this.lookingAt(TokenType.LT2)) {
            return this.parseReifiedTriple();
        }
        if (this.lookingAt(TokenType.L_TRIPLE)) {
            return this.parseTripleTerm();
        }
        Node node = this.node();
        return node;
    }

    private Node term(String posnLabel) {
        if (this.lookingAt(TokenType.L_TRIPLE)) {
            return this.parseTripleTerm();
        }
        if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            Token t = this.peekToken();
            if (!this.lookingAt(TokenType.RBRACKET)) {
                this.exception(this.peekToken(), "Bad %s in RDF triple. Expected ] after [", posnLabel, this.peekToken().text());
            }
            this.nextToken();
            return this.profile.createBlankNode(this.currentGraph, t.getLine(), t.getColumn());
        }
        if (!this.lookingAt(TokenType.NODE)) {
            this.exception(this.peekToken(), "Bad %s in RDF-star triple: %s", posnLabel, this.peekToken().text());
        }
        Node node = this.node();
        return node;
    }

    protected final void triplesSameSubject() {
        Node subject = this.subject();
        if (subject == null) {
            this.exception(this.peekToken(), "Not recognized: expected node: %s", this.peekToken().text());
        }
        this.predicateObjectList(subject);
        this.expectEndOfTriples();
    }

    protected abstract void expectEndOfTriples();

    protected void expectEndOfTriplesTurtle() {
        if (this.isStrictMode()) {
            this.expect("Triples not terminated by DOT", TokenType.DOT);
        } else {
            this.expectOrEOF("Triples not terminated by DOT", TokenType.DOT);
        }
    }

    protected final boolean lookingAtIRIorBNode() {
        if (this.eof()) {
            return false;
        }
        Token t = this.peekToken();
        return t.isIRI() || t.isBNode();
    }

    protected final void predicateObjectList(Node subject) {
        this.predicateObjectItem(subject);
        while (this.lookingAt(TokenType.SEMICOLON)) {
            while (this.lookingAt(TokenType.SEMICOLON)) {
                this.nextToken();
            }
            if (!this.peekPredicate()) break;
            this.predicateObjectItem(subject);
        }
    }

    protected final void predicateObjectItem(Node subject) {
        Node predicate = this.predicate();
        this.objectList(subject, predicate);
    }

    protected final Node predicate() {
        if (this.lookingAt(TokenType.KEYWORD)) {
            Token kwToken = this.nextToken();
            String image = kwToken.getImage();
            if (image.equals(KW_A)) {
                return NodeConst.nodeRDFType;
            }
            if (!this.isStrictMode() && image.equals(KW_SAME_AS)) {
                return nodeSameAs;
            }
            this.exception(kwToken, "Unrecognized keyword: " + image, new Object[0]);
        }
        Token token = this.peekToken();
        Node n = this.node();
        if (n == null || !n.isURI()) {
            this.exception(token, "Expected IRI for predicate: got: %s", token);
        }
        return n;
    }

    protected final boolean peekPredicate() {
        if (this.lookingAt(TokenType.KEYWORD)) {
            String image = this.peekToken().getImage();
            if (image.equals(KW_A)) {
                return true;
            }
            return !this.isStrictMode() && image.equals(KW_SAME_AS);
        }
        if (this.lookingAt(TokenType.IRI)) {
            return true;
        }
        return this.lookingAt(TokenType.PREFIXED_NAME);
    }

    protected final Node node() {
        Node n = this.tokenAsNode(this.peekToken());
        if (n == null) {
            return null;
        }
        this.nextToken();
        return n;
    }

    protected final void objectList(Node subject, Node predicate) {
        while (true) {
            Node object = this.triplesNode();
            this.emitTriple(subject, predicate, object);
            this.possibleAnnotations(subject, predicate, object);
            if (!this.moreTokens() || !this.lookingAt(TokenType.COMMA)) break;
            this.nextToken();
        }
    }

    private void possibleAnnotations(Node subject, Node predicate, Node object) {
        while (this.lookingAt(TokenType.TILDE) || this.lookingAt(TokenType.L_ANN) || this.lookingAt(TokenType.VBAR)) {
            Token tokenReifer = this.peekToken();
            Node reif = this.possibleReifier(subject, predicate, object, tokenReifer.getLine(), tokenReifer.getColumn());
            Node tripleTerm = this.profile.createTripleTerm(subject, predicate, object, tokenReifer.getLine(), tokenReifer.getColumn());
            this.emit(reif, NodeConst.nodeReifies, tripleTerm);
            if (!this.lookingAt(TokenType.L_ANN)) continue;
            Token tNext = this.nextToken();
            if (this.lookingAt(TokenType.R_ANN)) {
                this.exception(tNext, "Empty annotation", new Object[0]);
            }
            this.predicateObjectList(reif);
            this.expect("Missing end annotation", TokenType.R_ANN);
        }
        return;
    }

    protected final Node triplesNode() {
        if (this.lookingAt(TokenType.NODE)) {
            Node n = this.node();
            return n;
        }
        if (this.lookingAt(TokenType.KEYWORD)) {
            Token tErr = this.peekToken();
            String image = this.peekToken().getImage();
            this.nextToken();
            if (image.equals(KW_TRUE)) {
                return NodeConst.nodeTrue;
            }
            if (image.equals(KW_FALSE)) {
                return NodeConst.nodeFalse;
            }
            if (image.equals(KW_A)) {
                this.exception(tErr, "Keyword 'a' not legal at this point", new Object[0]);
            }
            this.exception(tErr, "Unrecognized keyword: " + image, new Object[0]);
        }
        if (this.lookingAt(TokenType.LT2)) {
            return this.parseReifiedTriple();
        }
        if (this.lookingAt(TokenType.L_TRIPLE)) {
            return this.parseTripleTerm();
        }
        return this.triplesNodeCompound();
    }

    protected final boolean peekTriplesNodeCompound() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            return true;
        }
        if (this.lookingAt(TokenType.LBRACE)) {
            return true;
        }
        return this.lookingAt(TokenType.LPAREN);
    }

    protected final Node triplesNodeCompound() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            return this.triplesBlankNode();
        }
        if (this.lookingAt(TokenType.LBRACE)) {
            return this.triplesFormula();
        }
        if (this.lookingAt(TokenType.LPAREN)) {
            return this.triplesList();
        }
        this.exception(this.peekToken(), "Unrecognized (expected an RDF Term): " + String.valueOf(this.peekToken()), new Object[0]);
        return null;
    }

    protected final Node triplesBlankNode() {
        Token t = this.nextToken();
        Node subject = this.profile.createBlankNode(this.currentGraph, t.getLine(), t.getColumn());
        this.triplesBlankNode(subject);
        return subject;
    }

    protected final void triplesBlankNode(Node subject) {
        if (this.peekPredicate()) {
            this.predicateObjectList(subject);
        }
        this.expect("Triples not terminated properly in []-list", TokenType.RBRACKET);
    }

    protected final Node triplesFormula() {
        this.exception(this.peekToken(), "Not implemented (formulae, graph literals)", new Object[0]);
        return null;
    }

    protected final Node triplesList() {
        this.nextToken();
        Node lastCell = null;
        Node listHead = null;
        this.startList();
        while (true) {
            if (this.eof()) {
                this.exception(this.peekToken(), "Unterminated list", new Object[0]);
            }
            if (this.lookingAt(TokenType.RPAREN)) break;
            Token elementToken = this.peekToken();
            Node n = this.triplesNode();
            if (n == null) {
                this.exception(elementToken, "Malformed list", new Object[0]);
            }
            Node nextCell = this.profile.createBlankNode(this.currentGraph, elementToken.getLine(), elementToken.getColumn());
            if (listHead == null) {
                listHead = nextCell;
            }
            if (lastCell != null) {
                this.emitTriple(lastCell, NodeConst.nodeRest, nextCell);
            }
            lastCell = nextCell;
            this.emitTriple(nextCell, NodeConst.nodeFirst, n);
        }
        this.nextToken();
        if (lastCell == null) {
            this.finishList();
            return NodeConst.nodeNil;
        }
        this.emitTriple(lastCell, NodeConst.nodeRest, NodeConst.nodeNil);
        this.finishList();
        return listHead;
    }

    protected void finishList() {
    }

    protected void startList() {
    }

    protected final void emitTriple(Node subject, Node predicate, Node object) {
        this.emit(subject, predicate, object);
    }

    private final void emitPrefix(String prefix, String iriStr) {
        this.dest.prefix(prefix, iriStr);
    }

    private final void emitBase(String baseStr) {
        this.dest.base(baseStr);
    }

    private final void emitVersion(String versionStr) {
        this.dest.version(versionStr);
    }

    protected final Node tokenAsNode(Token token) {
        return this.profile.create(this.currentGraph, token);
    }
}

