/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.access.AccessGeoSPARQL;
import org.apache.jena.geosparql.implementation.access.AccessWGS84;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class GenericSpatialPropertyFunction
extends PFuncSimpleAndList {
    public static final int DEFAULT_LIMIT = -1;
    private SpatialIndex spatialIndex;
    private SpatialArguments spatialArguments;

    @Override
    public final QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        try {
            this.spatialIndex = SpatialIndexLib.require(execCxt);
            this.spatialArguments = this.extractObjectArguments(predicate, object, this.spatialIndex.getSrsInfo());
            return this.search(binding, execCxt, subject, this.spatialArguments.limit);
        }
        catch (SpatialIndexException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    protected abstract SpatialArguments extractObjectArguments(Node var1, PropFuncArg var2, SRSInfo var3);

    private QueryIterator search(Binding binding, ExecutionContext execCxt, Node subject, int limit) {
        if (subject.isURI() || subject.isBlank()) {
            boolean isMatched = this.checkBound(execCxt, subject);
            if (isMatched) {
                return QueryIterSingleton.create(binding, execCxt);
            }
            return QueryIterNullIterator.create(execCxt);
        }
        if (subject.isVariable()) {
            return this.checkUnbound(binding, execCxt, subject, limit);
        }
        throw new ExprEvalException("Not a URI, Blank or variable: " + FmtUtils.stringForNode(subject));
    }

    private boolean checkBound(ExecutionContext execCxt, Node subject) {
        try {
            Graph graph = execCxt.getActiveGraph();
            Iterator<Triple> spatialTriples = AccessGeoSPARQL.containsGeoLiterals(graph) ? AccessGeoSPARQL.findSpecificGeoLiteralsByFeature(graph, subject) : (AccessWGS84.containsGeoLiteralProperties(graph) ? AccessWGS84.findGeoLiteralsAsTriples(graph, subject) : Iter.empty());
            boolean isMatched = Iter.anyMatch(spatialTriples, triple -> {
                Node geometryLiteral = triple.getObject();
                GeometryWrapper targetGeometryWrapper = GeometryWrapper.extract(geometryLiteral);
                boolean isMatch = this.checkSecondFilter(this.spatialArguments, targetGeometryWrapper);
                return isMatch;
            });
            return isMatched;
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    protected abstract boolean checkSecondFilter(SpatialArguments var1, GeometryWrapper var2);

    protected abstract boolean requireSecondFilter();

    private QueryIterator checkUnbound(Binding binding, ExecutionContext execCxt, Node subject, int limit) {
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        SearchEnvelope searchEnvelope = this.spatialArguments.searchEnvelope;
        Graph activeGraph = execCxt.getActiveGraph();
        Node graphName = SpatialIndexLib.unwrapGraphName(activeGraph);
        Collection<Node> features = searchEnvelope.check(this.spatialIndex, graphName);
        Var subjectVar = Var.alloc(subject.getName());
        Stream<Node> stream = features.stream();
        if (this.requireSecondFilter()) {
            stream = stream.filter(feature -> this.checkBound(execCxt, (Node)feature));
        }
        Iterator<Binding> iterator = stream.map(feature -> BindingFactory.binding(binding, subjectVar, feature)).limit(limit).iterator();
        return QueryIterPlainWrapper.create(iterator, execCxt);
    }
}

