/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import org.apache.jena.geosparql.implementation.great_circle.LatLonPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public class Angle {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double PI_AND_HALF = 4.71238898038469;

    public static final double find(double x1, double y1, double x2, double y2) {
        boolean x2Small;
        double numer = Math.abs(y1 - y2);
        double denom = Math.hypot(x1 - x2, numer);
        double result = Math.acos(numer / denom);
        boolean y2Small = y2 < y1;
        boolean bl = x2Small = x2 < x1;
        if (y2Small && x2Small) {
            result += Math.PI;
        } else if (y2Small && !x2Small) {
            result += 1.5707963267948966;
        } else if (x2Small) {
            result += 4.71238898038469;
        }
        return result;
    }

    public static final double find(LatLonPoint point1, LatLonPoint point2) {
        double lat1 = point1.getLat();
        double lon1 = point1.getLon();
        double lat2 = point2.getLat();
        double lon2 = point2.getLon();
        return Angle.find(lon1, lat1, lon2, lat2);
    }

    public static final double find(Point point1, Point point2) {
        double x1 = point1.getX();
        double y1 = point1.getY();
        double x2 = point2.getX();
        double y2 = point2.getY();
        return Angle.find(x1, y1, x2, y2);
    }

    public static final double find(Coordinate coord1, Coordinate coord2) {
        double x1 = coord1.getX();
        double y1 = coord1.getY();
        double x2 = coord2.getX();
        double y2 = coord2.getY();
        return Angle.find(x1, y1, x2, y2);
    }
}

