/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import jakarta.servlet.ServletContext;
import java.util.function.Function;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

class DataAccessLib {
    DataAccessLib() {
    }

    static SecurityContext getSecurityContext(HttpAction action, DatasetGraph dataset, Function<HttpAction, String> requestUser) {
        AuthorizationService registry = DataAccessLib.getAuthorizationService(action, dataset);
        if (registry == null) {
            ServletOps.errorOccurred("Internal Server Error");
        }
        SecurityContext sCxt = null;
        String user = requestUser.apply(action);
        sCxt = registry.get(user);
        if (sCxt == null) {
            sCxt = DataAccessLib.noSecurityPolicy();
        }
        return sCxt;
    }

    static AuthorizationService getAuthorizationService(HttpAction action, DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphAccessControl) {
            DatasetGraphAccessControl dsgAcc = (DatasetGraphAccessControl)dsg;
            return dsgAcc.getAuthService();
        }
        return (AuthorizationService)dsg.getContext().get(DataAccessCtl.symAuthorizationService);
    }

    static SecurityContext noSecurityPolicy() {
        ServletOps.errorForbidden();
        throw new InternalError();
    }

    static DatasetGraph decideDataset(HttpAction action, Function<HttpAction, String> requestUser) {
        DatasetGraph dsg = action.getDataset();
        if (dsg == null) {
            return dsg;
        }
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return dsg;
        }
        SecurityContext sCxt = DataAccessLib.getSecurityContext(action, dsg, requestUser);
        dsg = DatasetGraphAccessControl.removeWrapper(dsg);
        dsg = DataAccessCtl.filteredDataset(dsg, sCxt);
        return dsg;
    }

    static void set(ServletContext cxt, AuthorizationService authorizationService) {
        cxt.setAttribute("org.apache.jena.fuseki:AuthorizationService", authorizationService);
    }

    static AuthorizationService get(ServletContext cxt) {
        return (AuthorizationService)cxt.getAttribute("org.apache.jena.fuseki:AuthorizationService");
    }
}

