/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Cache;

class CacheOps {
    CacheOps() {
    }

    public static <K, V> V getOrFill(Cache<K, V> cache, K key, Callable<V> callable) {
        V value = cache.getIfPresent(key);
        if (value == null) {
            try {
                value = callable.call();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception e2) {
                throw new AtlasException("Exception on cache fill", e2);
            }
            if (value != null) {
                cache.put(key, value);
            }
        }
        return value;
    }

    public static <K, V> V getOrFill(Cache<K, V> cache, K key, Function<K, V> function) {
        V value = cache.getIfPresent(key);
        if (value == null && (value = function.apply(key)) != null) {
            cache.put(key, value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrFillSync(Cache<K, V> cache, K key, Callable<V> callable) {
        Cache<K, V> cache2 = cache;
        synchronized (cache2) {
            return CacheOps.getOrFill(cache, key, callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrFillSync(Cache<K, V> cache, K key, Function<K, V> function) {
        Cache<K, V> cache2 = cache;
        synchronized (cache2) {
            return CacheOps.getOrFill(cache, key, function);
        }
    }
}

