/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.parser.Parameters;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.system.G;

public class EvalSparql {
    private static boolean USE_QueryTransformOps = true;

    public static Collection<Node> evalSparqlComponent(Graph data, Node node, SparqlComponent sparqlComponent) {
        EvalSparql.checkForRequiredParams(data, node, sparqlComponent);
        Query query = sparqlComponent.getQuery();
        if (!query.isSelectType()) {
            throw new ShaclException("Not a SELECT query");
        }
        if (USE_QueryTransformOps) {
            DatasetGraph dsg = DatasetGraphFactory.wrap((Graph)data);
            Map<Var, Node> substitutions = EvalSparql.parametersToSyntaxSubstitutions(data, node, sparqlComponent.getParams());
            Query query2 = QueryTransformOps.replaceVars((Query)query, substitutions);
            try (QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (DatasetGraph)dsg);){
                Collection<Node> collection = EvalSparql.evalSparqlOneVar(qExec);
                return collection;
            }
        }
        Model model = ModelFactory.createModelForGraph((Graph)data);
        QuerySolutionMap qsm = EvalSparql.parametersToPreBinding(model, node, sparqlComponent.getParams());
        try (QueryExecution qExec = QueryExecution.create().query(query).model(model).initialBinding((QuerySolution)qsm).build();){
            Collection<Node> collection = EvalSparql.evalSparqlOneVar(qExec);
            return collection;
        }
    }

    public static Collection<Node> evalSparqlOneVar(QueryExecution qExec) {
        List vars = qExec.getQuery().getProjectVars();
        if (vars.size() != 1) {
            throw new ShaclException("Except SELECT query with one output variable.");
        }
        Var var = (Var)vars.get(0);
        return Iter.iter((Iterator)qExec.execSelect()).map(row -> row.get(var.getVarName()).asNode()).toSet();
    }

    private static Map<Var, Node> parametersToSyntaxSubstitutions(Graph data, Node node, List<Parameter> params) {
        HashMap<Var, Node> substitions = new HashMap<Var, Node>();
        params.forEach(param -> {
            Node path = param.getParameterPath();
            Node v = G.getOneSP((Graph)data, (Node)node, (Node)path);
            substitions.put(Var.alloc((String)param.getSparqlName()), v);
        });
        return substitions;
    }

    private static QuerySolutionMap parametersToPreBinding(Model data, Node node, List<Parameter> params) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        params.forEach(param -> {
            Node path = param.getParameterPath();
            Node v = G.getOneSP((Graph)data.getGraph(), (Node)node, (Node)path);
            qsm.add(param.getSparqlName(), ModelUtils.convertGraphNodeToRDFNode((Node)v, (Model)data));
        });
        return qsm;
    }

    private static void checkForRequiredParams(Graph data, Node node, SparqlComponent sparqlComponent) {
        if (!Parameters.doesShapeHaveAllParameters(data, node, sparqlComponent.getRequiredParameters())) {
            throw new ShaclException("Missing required parameter: " + String.valueOf(node));
        }
    }
}

