/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import jakarta.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.ExpungeRequest;

public class ExpungeCommandParser
extends AbstractUidCommandParser {
    @Inject
    public ExpungeCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.EXPUNGE_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] uidSet = this.parseIdRange(request, useUids, session);
        request.eol();
        return new ExpungeRequest(tag, uidSet);
    }

    private IdRange[] parseIdRange(ImapRequestLineReader request, boolean useUids, ImapSession session) throws DecodingException {
        if (useUids) {
            return request.parseIdRange(session);
        }
        return null;
    }
}

