/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import java.util.zip.CRC32;

public class Crc {
    private static final ThreadLocal<CRC32> crc32 = ThreadLocal.withInitial(CRC32::new);
    private static final byte[] initialBytes = new byte[]{-6, 45, 85, -54};
    private static final int CRC24_INIT = 8867936;
    private static final int CRC24_POLY = 26693387;

    public static <B> int computeCrc32(B buffer, PrimitiveCodec<B> codec) {
        CRC32 crc = Crc.newCrc32();
        codec.updateCrc(buffer, crc);
        return (int)crc.getValue();
    }

    private static CRC32 newCrc32() {
        CRC32 crc = crc32.get();
        crc.reset();
        crc.update(initialBytes);
        return crc;
    }

    public static int computeCrc24(long bytes, int len) {
        int crc = 8867936;
        while (len-- > 0) {
            crc ^= (int)(bytes & 0xFFL) << 16;
            bytes >>= 8;
            for (int i = 0; i < 8; ++i) {
                if (((crc <<= 1) & 0x1000000) == 0) continue;
                crc ^= 0x1974F0B;
            }
        }
        return crc;
    }
}

