/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.BitwiseUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class BitwiseNotColumnTransformer
extends UnaryColumnTransformer {
    public BitwiseNotColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, int i) {
        long leftValue = column.getLong(i);
        long currentValue = BitwiseUtils.bitwiseNotTransform(leftValue);
        columnBuilder.writeLong(currentValue);
    }
}

