/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.metrics.MessageMetrics;
import org.apache.ratis.grpc.metrics.intercept.server.MetricServerInterceptor;
import org.apache.ratis.grpc.server.GrpcAdminProtocolService;
import org.apache.ratis.grpc.server.GrpcClientProtocolService;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServerProtocolService;
import org.apache.ratis.grpc.server.GrpcServices;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpcWithProxy;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServicesImpl
extends RaftServerRpcWithProxy<GrpcServerProtocolClient, PeerProxyMap<GrpcServerProtocolClient>>
implements GrpcServices {
    static final Logger LOG = LoggerFactory.getLogger(GrpcServicesImpl.class);
    public static final String GRPC_SEND_SERVER_REQUEST = JavaUtils.getClassSimpleName(GrpcServicesImpl.class) + ".sendRequest";
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Supplier<InetSocketAddress> addressSupplier;
    private final Supplier<InetSocketAddress> clientServerAddressSupplier;
    private final Supplier<InetSocketAddress> adminServerAddressSupplier;
    private final AsyncService asyncService = new AsyncService();
    private final ExecutorService executor;
    private final GrpcClientProtocolService clientProtocolService;
    private final MetricServerInterceptor serverInterceptor;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcServicesImpl(Builder b) {
        super(() -> ((RaftServer)b.server).getId(), id -> new PeerProxyMap(id.toString(), x$0 -> b.newGrpcServerProtocolClient(x$0)));
        NettyServerBuilder builder;
        this.executor = b.newExecutor();
        this.clientProtocolService = b.newGrpcClientProtocolService(this.executor);
        this.serverInterceptor = b.newMetricServerInterceptor();
        Server server = b.newServer(this.clientProtocolService, this.serverInterceptor);
        this.servers.put(GrpcServerProtocolService.class.getSimpleName(), server);
        this.addressSupplier = GrpcServicesImpl.newAddressSupplier(b.serverPort, server);
        if (b.separateAdminServer()) {
            builder = b.newNettyServerBuilderForAdmin();
            GrpcServicesImpl.addAdminService(builder, (AdminAsynchronousProtocol)b.server, this.serverInterceptor);
            Server adminServer = b.buildServer(builder, EnumSet.of(GrpcServices.Type.ADMIN));
            this.servers.put(GrpcAdminProtocolService.class.getName(), adminServer);
            this.adminServerAddressSupplier = GrpcServicesImpl.newAddressSupplier(b.adminPort, adminServer);
        } else {
            this.adminServerAddressSupplier = this.addressSupplier;
        }
        if (b.separateClientServer()) {
            builder = b.newNettyServerBuilderForClient();
            GrpcServicesImpl.addClientService(builder, this.clientProtocolService, this.serverInterceptor);
            Server clientServer = b.buildServer(builder, EnumSet.of(GrpcServices.Type.CLIENT));
            this.servers.put(GrpcClientProtocolService.class.getName(), clientServer);
            this.clientServerAddressSupplier = GrpcServicesImpl.newAddressSupplier(b.clientPort, clientServer);
        } else {
            this.clientServerAddressSupplier = this.addressSupplier;
        }
    }

    static MemoizedSupplier<InetSocketAddress> newAddressSupplier(int port, Server server) {
        return JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : server.getPort()));
    }

    static void addClientService(NettyServerBuilder builder, GrpcClientProtocolService client, ServerInterceptor interceptor) {
        builder.addService(ServerInterceptors.intercept((BindableService)client, (ServerInterceptor[])new ServerInterceptor[]{interceptor}));
    }

    static void addAdminService(NettyServerBuilder builder, AdminAsynchronousProtocol admin, ServerInterceptor interceptor) {
        GrpcAdminProtocolService service = new GrpcAdminProtocolService(admin);
        builder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor}));
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public void startImpl() {
        for (Server server : this.servers.values()) {
            try {
                server.start();
            }
            catch (IOException e) {
                ExitUtils.terminate((int)1, (String)"Failed to start Grpc server", (Throwable)e, (Logger)LOG);
            }
            LOG.info("{}: {} started, listening on {}", new Object[]{this.getId(), JavaUtils.getClassSimpleName(this.getClass()), server.getPort()});
        }
    }

    public void closeImpl() throws IOException {
        for (Map.Entry<String, Server> server : this.servers.entrySet()) {
            String name = this.getId() + ": shutdown server " + server.getKey();
            LOG.info("{} now", (Object)name);
            Server s = server.getValue().shutdownNow();
            super.closeImpl();
            try {
                s.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw IOUtils.toInterruptedIOException((String)(name + " failed"), (InterruptedException)e);
            }
            LOG.info("{} successfully", (Object)name);
        }
        this.serverInterceptor.close();
        ConcurrentUtils.shutdownAndWait((ExecutorService)this.executor);
    }

    public void notifyNotLeader(RaftGroupId groupId) {
        this.clientProtocolService.closeAllOrderedRequestStreamObservers(groupId);
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    public InetSocketAddress getClientServerAddress() {
        return this.clientServerAddressSupplier.get();
    }

    public InetSocketAddress getAdminServerAddress() {
        return this.adminServerAddressSupplier.get();
    }

    public RaftServerAsynchronousProtocol async() {
        return this.asyncService;
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)this.getProxies().getProxy(target)).requestVote(request);
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)this.getProxies().getProxy(target)).startLeaderElection(request);
    }

    MessageMetrics getMessageMetrics() {
        return this.serverInterceptor.getMetrics();
    }

    public static final class Builder {
        private RaftServer server;
        private GrpcServices.Customizer customizer;
        private String adminHost;
        private int adminPort;
        private SslContext adminSslContext;
        private String clientHost;
        private int clientPort;
        private SslContext clientSslContext;
        private String serverHost;
        private int serverPort;
        private SslContext serverSslContextForServer;
        private SslContext serverSslContextForClient;
        private SizeInBytes messageSizeMax;
        private SizeInBytes flowControlWindow;
        private TimeDuration requestTimeoutDuration;
        private boolean separateHeartbeatChannel;

        private Builder() {
        }

        public Builder setServer(RaftServer raftServer) {
            this.server = raftServer;
            RaftProperties properties = this.server.getProperties();
            this.adminHost = GrpcConfigKeys.Admin.host(properties);
            this.adminPort = GrpcConfigKeys.Admin.port(properties);
            this.clientHost = GrpcConfigKeys.Client.host(properties);
            this.clientPort = GrpcConfigKeys.Client.port(properties);
            this.serverHost = GrpcConfigKeys.Server.host(properties);
            this.serverPort = GrpcConfigKeys.Server.port(properties);
            this.messageSizeMax = GrpcConfigKeys.messageSizeMax(properties, arg_0 -> ((Logger)LOG).info(arg_0));
            this.flowControlWindow = GrpcConfigKeys.flowControlWindow(properties, arg_0 -> ((Logger)LOG).info(arg_0));
            this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)properties);
            this.separateHeartbeatChannel = GrpcConfigKeys.Server.heartbeatChannel(properties);
            SizeInBytes appenderBufferSize = RaftServerConfigKeys.Log.Appender.bufferByteLimit((RaftProperties)properties);
            SizeInBytes gap = SizeInBytes.ONE_MB;
            long diff = this.messageSizeMax.getSize() - appenderBufferSize.getSize();
            if (diff < gap.getSize()) {
                throw new IllegalArgumentException("Illegal configuration: raft.grpc.message.size.max(= " + this.messageSizeMax + ") must be " + gap + " larger than " + "raft.server.log.appender.buffer.byte-limit" + "(= " + appenderBufferSize + ").");
            }
            return this;
        }

        public Builder setCustomizer(GrpcServices.Customizer customizer) {
            this.customizer = customizer != null ? customizer : GrpcServices.Customizer.getDefaultInstance();
            return this;
        }

        private GrpcServerProtocolClient newGrpcServerProtocolClient(RaftPeer target) {
            return new GrpcServerProtocolClient(target, this.flowControlWindow.getSizeInt(), this.requestTimeoutDuration, this.serverSslContextForClient, this.separateHeartbeatChannel);
        }

        private ExecutorService newExecutor() {
            RaftProperties properties = this.server.getProperties();
            return ConcurrentUtils.newThreadPoolWithMax((boolean)GrpcConfigKeys.Server.asyncRequestThreadPoolCached(properties), (int)GrpcConfigKeys.Server.asyncRequestThreadPoolSize(properties), (String)(this.server.getId() + "-request-"));
        }

        private GrpcClientProtocolService newGrpcClientProtocolService(ExecutorService executor) {
            return new GrpcClientProtocolService(() -> ((RaftServer)this.server).getId(), (RaftClientAsynchronousProtocol)this.server, executor);
        }

        private GrpcServerProtocolService newGrpcServerProtocolService() {
            return new GrpcServerProtocolService(() -> ((RaftServer)this.server).getId(), this.server);
        }

        private MetricServerInterceptor newMetricServerInterceptor() {
            return new MetricServerInterceptor(() -> ((RaftServer)this.server).getId(), JavaUtils.getClassSimpleName(this.getClass()) + "_" + this.serverPort);
        }

        Server buildServer(NettyServerBuilder builder, EnumSet<GrpcServices.Type> types) {
            return this.customizer.customize(builder, types).build();
        }

        private NettyServerBuilder newNettyServerBuilderForServer() {
            return this.newNettyServerBuilder(this.serverHost, this.serverPort, this.serverSslContextForServer);
        }

        private NettyServerBuilder newNettyServerBuilderForAdmin() {
            return this.newNettyServerBuilder(this.adminHost, this.adminPort, this.adminSslContext);
        }

        private NettyServerBuilder newNettyServerBuilderForClient() {
            return this.newNettyServerBuilder(this.clientHost, this.clientPort, this.clientSslContext);
        }

        private NettyServerBuilder newNettyServerBuilder(String hostname, int port, SslContext sslContext) {
            InetSocketAddress address = hostname == null || hostname.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
            NettyServerBuilder nettyServerBuilder = NettyServerBuilder.forAddress((SocketAddress)address).withChildOption(ChannelOption.SO_REUSEADDR, (Object)true).maxInboundMessageSize(this.messageSizeMax.getSizeInt()).flowControlWindow(this.flowControlWindow.getSizeInt());
            if (sslContext != null) {
                LOG.info("Setting TLS for {}", (Object)address);
                nettyServerBuilder.sslContext(sslContext);
            }
            return nettyServerBuilder;
        }

        private boolean separateAdminServer() {
            return this.adminPort > 0 && this.adminPort != this.serverPort;
        }

        private boolean separateClientServer() {
            return this.clientPort > 0 && this.clientPort != this.serverPort;
        }

        Server newServer(GrpcClientProtocolService client, ServerInterceptor interceptor) {
            EnumSet<GrpcServices.Type> types = EnumSet.of(GrpcServices.Type.SERVER);
            NettyServerBuilder serverBuilder = this.newNettyServerBuilderForServer();
            GrpcServerProtocolService service = this.newGrpcServerProtocolService();
            serverBuilder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor}));
            if (!this.separateAdminServer()) {
                types.add(GrpcServices.Type.ADMIN);
                GrpcServicesImpl.addAdminService(serverBuilder, (AdminAsynchronousProtocol)this.server, interceptor);
            }
            if (!this.separateClientServer()) {
                types.add(GrpcServices.Type.CLIENT);
                GrpcServicesImpl.addClientService(serverBuilder, client, interceptor);
            }
            return this.buildServer(serverBuilder, types);
        }

        public GrpcServicesImpl build() {
            return new GrpcServicesImpl(this);
        }

        public Builder setAdminSslContext(SslContext adminSslContext) {
            this.adminSslContext = adminSslContext;
            return this;
        }

        public Builder setClientSslContext(SslContext clientSslContext) {
            this.clientSslContext = clientSslContext;
            return this;
        }

        public Builder setServerSslContextForServer(SslContext serverSslContextForServer) {
            this.serverSslContextForServer = serverSslContextForServer;
            return this;
        }

        public Builder setServerSslContextForClient(SslContext serverSslContextForClient) {
            this.serverSslContextForClient = serverSslContextForClient;
            return this;
        }
    }

    class AsyncService
    implements RaftServerAsynchronousProtocol {
        AsyncService() {
        }

        public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto request) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        public CompletableFuture<RaftProtos.ReadIndexReplyProto> readIndexAsync(RaftProtos.ReadIndexRequestProto request) throws IOException {
            CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)GrpcServicesImpl.this.getId(), null, (Object[])new Object[]{request});
            final CompletableFuture<RaftProtos.ReadIndexReplyProto> f = new CompletableFuture<RaftProtos.ReadIndexReplyProto>();
            StreamObserver<RaftProtos.ReadIndexReplyProto> s = new StreamObserver<RaftProtos.ReadIndexReplyProto>(){

                public void onNext(RaftProtos.ReadIndexReplyProto reply) {
                    f.complete(reply);
                }

                public void onError(Throwable throwable) {
                    f.completeExceptionally(throwable);
                }

                public void onCompleted() {
                }
            };
            RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
            ((GrpcServerProtocolClient)GrpcServicesImpl.this.getProxies().getProxy(target)).readIndex(request, s);
            return f;
        }
    }
}

