/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.disk;

import java.io.File;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.storageengine.load.disk.InheritSystemMultiDisksStrategySelector;
import org.apache.iotdb.db.storageengine.load.disk.MinIOSelector;

public interface ILoadDiskSelector {
    public File selectTargetDirectory(File var1, String var2, boolean var3, int var4) throws DiskSpaceInsufficientException, LoadFileException;

    public static ILoadDiskSelector initDiskSelector(String selectStrategy, String[] dirs, DiskDirectorySelector selector) {
        InheritSystemMultiDisksStrategySelector diskSelector;
        switch (LoadDiskSelectorType.fromValue(selectStrategy)) {
            case INHERIT_SYSTEM_MULTI_DISKS_SELECT_STRATEGY: {
                diskSelector = new InheritSystemMultiDisksStrategySelector(selector);
                break;
            }
            default: {
                diskSelector = new MinIOSelector(dirs, selector);
            }
        }
        return diskSelector;
    }

    public static enum LoadDiskSelectorType {
        MIN_IO_FIRST("MIN_IO_FIRST"),
        INHERIT_SYSTEM_MULTI_DISKS_SELECT_STRATEGY("INHERIT_SYSTEM_MULTI_DISKS_SELECT_STRATEGY"),
        INHERIT_LOAD("INHERIT_LOAD");

        private final String value;

        private LoadDiskSelectorType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LoadDiskSelectorType fromValue(String value) {
            if (value.equalsIgnoreCase(MIN_IO_FIRST.getValue())) {
                return MIN_IO_FIRST;
            }
            if (value.equalsIgnoreCase(INHERIT_SYSTEM_MULTI_DISKS_SELECT_STRATEGY.getValue())) {
                return INHERIT_SYSTEM_MULTI_DISKS_SELECT_STRATEGY;
            }
            if (value.equalsIgnoreCase(INHERIT_LOAD.getValue())) {
                return INHERIT_LOAD;
            }
            return MIN_IO_FIRST;
        }
    }

    @FunctionalInterface
    public static interface DiskDirectorySelector {
        public File selectDirectory(File var1, String var2, int var3) throws DiskSpaceInsufficientException, LoadFileException;
    }
}

