/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class OffsetOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(OffsetOperator.class);
    private final OperatorContext operatorContext;
    private long remainingOffset;
    private final Operator child;

    public OffsetOperator(OperatorContext operatorContext, long offset, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be at least zero");
        this.remainingOffset = offset;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    public OffsetOperator(OffsetOperator offsetOperator, Operator child) {
        this.operatorContext = offsetOperator.operatorContext;
        this.remainingOffset = offsetOperator.remainingOffset;
        this.child = child;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        if (this.remainingOffset > 0L) {
            int offset = (int)Math.min(this.remainingOffset, (long)block.getPositionCount());
            this.remainingOffset -= (long)offset;
            return block.getRegion(offset, block.getPositionCount() - offset);
        }
        return block;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemoryWithCounter();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

