/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RollbackCreateTablePlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.confignode.procedure.state.schema.CreateTableState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, CreateTableState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTableProcedure.class);
    protected String database;
    protected TsTable table;

    public CreateTableProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public CreateTableProcedure(String database, TsTable table, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.database = database;
        this.table = table;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateTableState state) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkTableExistence(ConfigNodeProcedureEnv env) {
        try {
            if (env.getConfigManager().getClusterSchemaManager().getTableIfExists(this.database, this.table.getTableName()).isPresent()) {
                this.setFailure(new ProcedureException((Throwable)new IoTDBException(String.format("Table '%s.%s' already exists.", this.database, this.table.getTableName()), TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode())));
            } else {
                TDatabaseSchema schema = env.getConfigManager().getClusterSchemaManager().getDatabaseSchemaByName(this.database);
                if (!this.table.getPropValue("ttl").isPresent() && schema.isSetTTL() && schema.getTTL() != Long.MAX_VALUE) {
                    this.table.addProp("ttl", String.valueOf(schema.getTTL()));
                }
                this.setNextState(CreateTableState.PRE_CREATE);
            }
        }
        catch (MetadataException | DatabaseNotExistsException e) {
            this.setFailure(new ProcedureException(e));
        }
    }

    protected void preCreateTable(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(new PreCreateTablePlan(this.database, this.table), env, LOGGER);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(CreateTableState.PRE_RELEASE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    private void preReleaseTable(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.preReleaseTable(this.database, this.table, env.getConfigManager(), null);
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to sync table {}.{} pre-create info to DataNode, failure results: {}", new Object[]{this.database, this.table.getTableName(), failedResults});
            this.setFailure(new ProcedureException(new MetadataException("Pre create table failed")));
            return;
        }
        this.setNextState(CreateTableState.COMMIT_CREATE);
    }

    private void commitCreateTable(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(this.isGeneratedByPipe ? new PipeEnrichedPlan(new CommitCreateTablePlan(this.database, this.table.getTableName())) : new CommitCreateTablePlan(this.database, this.table.getTableName()), env, LOGGER);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(CreateTableState.COMMIT_RELEASE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    private void commitReleaseTable(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.commitReleaseTable(this.database, this.table.getTableName(), env.getConfigManager(), null);
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to sync table {}.{} commit-create info to DataNode {}, failure results: ", new Object[]{this.database, this.table.getTableName(), failedResults});
        }
    }

    @Override
    protected boolean isRollbackSupported(CreateTableState state) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreateTableState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case PRE_CREATE: {
                    LOGGER.info("Start rollback pre create table {}.{}", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackCreate(env);
                    return;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release table {}.{}", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackPreRelease(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback CreateTable-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    protected void rollbackCreate(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(new RollbackCreateTablePlan(this.database, this.table.getTableName()), env, LOGGER);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback table creation {}.{}", (Object)this.database, (Object)this.table.getTableName());
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    private void rollbackPreRelease(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.rollbackPreRelease(this.database, this.table.getTableName(), env.getConfigManager(), null);
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to sync table {}.{} rollback-create info to DataNode {}, failure results: ", new Object[]{this.database, this.table.getTableName(), failedResults});
            this.setFailure(new ProcedureException(new MetadataException("Rollback create table failed")));
        }
    }

    @Override
    protected CreateTableState getState(int stateId) {
        return CreateTableState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateTableState state) {
        return state.ordinal();
    }

    @Override
    protected CreateTableState getInitialState() {
        return CreateTableState.CHECK_TABLE_EXISTENCE;
    }

    public String getDatabase() {
        return this.database;
    }

    public TsTable getTable() {
        return this.table;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_CREATE_TABLE_PROCEDURE.getTypeCode() : ProcedureType.CREATE_TABLE_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
    }

    protected void innerSerialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        this.table.serialize((OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.database = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.table = TsTable.deserialize((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableProcedure that = (CreateTableProcedure)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table) && this.isGeneratedByPipe == that.isGeneratedByPipe;
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table, this.isGeneratedByPipe);
    }
}

