"""Unit tests for all time series regressors."""

__author__ = ["felipeangelimvieira"]

from sktime.tests.test_all_estimators import BaseFixtureGenerator, QuickTester


class RegressionDatasetFixtureGenerator(BaseFixtureGenerator):
    """Fixture generator for classifier tests.

    Fixtures parameterized
    ----------------------
    estimator_class: estimator inheriting from BaseObject
        ranges over estimator classes not excluded by EXCLUDE_ESTIMATORS, EXCLUDED_TESTS
    estimator_instance: instance of estimator inheriting from BaseObject
        ranges over estimator classes not excluded by EXCLUDE_ESTIMATORS, EXCLUDED_TESTS
        instances are generated by create_test_instance class method
    scenario: instance of TestScenario
        ranges over all scenarios returned by retrieve_scenarios
    """

    estimator_type_filter = "dataset_regression"


class TestAllRegressionDatasets(RegressionDatasetFixtureGenerator, QuickTester):
    """Module level tests for all sktime regression datasets"""

    def test_tag_is_univariate(self, estimator_instance):
        """Check if the dataset is univariate."""
        is_univariate = estimator_instance.get_tag("is_univariate")
        X = estimator_instance.load("X")
        assert X.shape[1] == 1 if is_univariate else X.shape[1] > 1
