/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;

public class TsFileStatisticReader
implements Closeable {
    private final TsFileSequenceReader reader;

    public TsFileStatisticReader(String filePath) throws IOException {
        this.reader = new TsFileSequenceReader(filePath);
    }

    public List<ChunkGroupStatistics> getChunkGroupStatisticsList() throws IOException {
        TsFileDeviceIterator allDevicesIteratorWithIsAligned = this.reader.getAllDevicesIteratorWithIsAligned();
        ArrayList<ChunkGroupStatistics> chunkGroupStatisticsList = new ArrayList<ChunkGroupStatistics>();
        while (allDevicesIteratorWithIsAligned.hasNext()) {
            Pair deviceWithIsAligned = allDevicesIteratorWithIsAligned.next();
            IDeviceID deviceId = (IDeviceID)deviceWithIsAligned.left;
            ChunkGroupStatistics chunkGroupStatistics = new ChunkGroupStatistics(deviceId);
            Iterator measurementChunkMetadataListMapIterator = this.reader.getMeasurementChunkMetadataListMapIterator(deviceId);
            while (measurementChunkMetadataListMapIterator.hasNext()) {
                Map measurementChunkMetadataListMap = (Map)measurementChunkMetadataListMapIterator.next();
                for (Map.Entry measurementChunkMetadataList : measurementChunkMetadataListMap.entrySet()) {
                    List chunkMetadataList = (List)measurementChunkMetadataList.getValue();
                    chunkGroupStatistics.chunkMetadataList.addAll(chunkMetadataList);
                    chunkGroupStatistics.totalChunkNum += chunkMetadataList.size();
                }
            }
            chunkGroupStatisticsList.add(chunkGroupStatistics);
        }
        return chunkGroupStatisticsList;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static class ChunkGroupStatistics {
        private final IDeviceID deviceID;
        private final List<ChunkMetadata> chunkMetadataList;
        private int totalChunkNum = 0;

        private ChunkGroupStatistics(IDeviceID deviceId) {
            this.deviceID = deviceId;
            this.chunkMetadataList = new ArrayList<ChunkMetadata>();
        }

        public IDeviceID getDeviceID() {
            return this.deviceID;
        }

        public List<ChunkMetadata> getChunkMetadataList() {
            return this.chunkMetadataList;
        }

        public int getTotalChunkNum() {
            return this.totalChunkNum;
        }
    }
}

