/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TopicMeta {
    private String topicName;
    private long creationTime;
    private TopicConfig config;
    private Set<String> subscribedConsumerGroupIds;

    private TopicMeta() {
        this.config = new TopicConfig(new HashMap());
        this.subscribedConsumerGroupIds = new HashSet<String>();
    }

    public TopicMeta(String topicName, long creationTime, Map<String, String> topicAttributes) {
        this.topicName = topicName;
        this.creationTime = creationTime;
        this.config = new TopicConfig(topicAttributes);
        this.subscribedConsumerGroupIds = new HashSet<String>();
    }

    public TopicMeta deepCopy() {
        TopicMeta copied = new TopicMeta();
        copied.topicName = this.topicName;
        copied.creationTime = this.creationTime;
        copied.config = new TopicConfig(new HashMap(this.config.getAttribute()));
        copied.subscribedConsumerGroupIds = new HashSet<String>(this.subscribedConsumerGroupIds);
        return copied;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public TopicConfig getConfig() {
        return this.config;
    }

    @TestOnly
    public boolean addSubscribedConsumerGroup(String consumerGroupId) {
        return this.subscribedConsumerGroupIds.add(consumerGroupId);
    }

    @TestOnly
    public void removeSubscribedConsumerGroup(String consumerGroupId) {
        this.subscribedConsumerGroupIds.remove(consumerGroupId);
    }

    @TestOnly
    public Set<String> getSubscribedConsumerGroupIds() {
        return this.subscribedConsumerGroupIds;
    }

    @TestOnly
    public boolean isSubscribedByConsumerGroup(String consumerGroupId) {
        return this.subscribedConsumerGroupIds.contains(consumerGroupId);
    }

    @TestOnly
    public boolean hasSubscribedConsumerGroup() {
        return !this.subscribedConsumerGroupIds.isEmpty();
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.config.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.config.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((int)this.subscribedConsumerGroupIds.size(), (OutputStream)outputStream);
        for (String subscribedConsumerGroupID : this.subscribedConsumerGroupIds) {
            ReadWriteIOUtils.write((String)subscribedConsumerGroupID, (OutputStream)outputStream);
        }
    }

    public static TopicMeta deserialize(InputStream inputStream) throws IOException {
        int i;
        TopicMeta topicMeta = new TopicMeta();
        topicMeta.topicName = ReadWriteIOUtils.readString((InputStream)inputStream);
        topicMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((InputStream)inputStream);
            String value = ReadWriteIOUtils.readString((InputStream)inputStream);
            topicMeta.config.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            topicMeta.subscribedConsumerGroupIds.add(ReadWriteIOUtils.readString((InputStream)inputStream));
        }
        return topicMeta;
    }

    public static TopicMeta deserialize(ByteBuffer byteBuffer) {
        int i;
        TopicMeta topicMeta = new TopicMeta();
        topicMeta.topicName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        topicMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            String value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            topicMeta.config.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            topicMeta.subscribedConsumerGroupIds.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        return topicMeta;
    }

    public Map<String, String> generateExtractorAttributes(String username) {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        extractorAttributes.put("source", "iotdb-source");
        extractorAttributes.put("inclusion", "data.insert");
        extractorAttributes.put("inclusion.exclusion", "data.delete");
        extractorAttributes.put("username", username);
        extractorAttributes.put("skipif", "no-privileges");
        extractorAttributes.putAll(this.config.getAttributeWithSqlDialect());
        if (this.config.isTableTopic()) {
            extractorAttributes.putAll(this.config.getAttributesWithSourceDatabaseAndTableName());
        } else {
            extractorAttributes.putAll(this.config.getAttributesWithSourcePathOrPattern());
        }
        extractorAttributes.putAll(this.config.getAttributesWithSourceTimeRange());
        extractorAttributes.putAll(this.config.getAttributesWithSourceRealtimeMode());
        extractorAttributes.putAll(this.config.getAttributesWithSourceMode());
        extractorAttributes.putAll(this.config.getAttributesWithSourceLooseRangeOrStrict());
        extractorAttributes.putAll(this.config.getAttributesWithSourcePrefix());
        return extractorAttributes;
    }

    public Map<String, String> generateProcessorAttributes() {
        return this.config.getAttributesWithProcessorPrefix();
    }

    public Map<String, String> generateConnectorAttributes(String consumerGroupId) {
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        connectorAttributes.put("sink", "subscription-sink");
        connectorAttributes.put("sink.topic", this.topicName);
        connectorAttributes.put("sink.consumer-group", consumerGroupId);
        connectorAttributes.putAll(this.config.getAttributesWithSinkFormat());
        connectorAttributes.putAll(this.config.getAttributesWithSinkPrefix());
        return connectorAttributes;
    }

    public boolean visibleUnder(boolean isTableModel) {
        Visibility visibility = VisibilityUtils.calculateFromTopicConfig(this.config);
        return VisibilityUtils.isCompatible(visibility, isTableModel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TopicMeta that = (TopicMeta)obj;
        return this.creationTime == that.creationTime && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.creationTime, this.config);
    }

    public String toString() {
        return "TopicMeta{topicName='" + this.topicName + "', creationTime=" + this.creationTime + ", config=" + this.config + '}';
    }
}

