/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.RateLimitingHandler;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerHelloHandler;

public class OpcServerTcpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final UaStackServer stackServer;

    public OpcServerTcpChannelInitializer(UaStackServer stackServer) {
        this.stackServer = stackServer;
    }

    protected void initChannel(SocketChannel channel) {
        this.stackServer.registerConnectedChannel((Channel)channel);
        channel.closeFuture().addListener(future -> this.stackServer.unregisterConnectedChannel((Channel)channel));
        channel.pipeline().addLast(new ChannelHandler[]{RateLimitingHandler.getInstance()});
        channel.pipeline().addLast(new ChannelHandler[]{new UascServerHelloHandler(this.stackServer, TransportProfile.TCP_UASC_UABINARY)});
    }
}

