/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.exchange.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.RequestType;
import org.apache.iotdb.db.pipe.processor.twostage.state.State;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CombineRequest
extends TPipeTransferReq {
    private String pipeName;
    private long creationTime;
    private int regionId;
    private String combineId;
    private State state;

    private CombineRequest() {
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public String getCombineId() {
        return this.combineId;
    }

    public State getState() {
        return this.state;
    }

    public static CombineRequest toTPipeTransferReq(String pipeName, long creationTime, int regionId, String combineId, State state) throws IOException {
        return new CombineRequest().convertToTPipeTransferReq(pipeName, creationTime, regionId, combineId, state);
    }

    public static CombineRequest fromTPipeTransferReq(TPipeTransferReq transferReq) throws Exception {
        return new CombineRequest().translateFromTPipeTransferReq(transferReq);
    }

    private CombineRequest convertToTPipeTransferReq(String pipeName, long creationTime, int regionId, String combineId, State state) throws IOException {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.state = state;
        this.combineId = combineId;
        this.version = IoTDBConnectorRequestVersion.VERSION_2.getVersion();
        this.type = RequestType.COMBINE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)pipeName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)creationTime, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)regionId, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)combineId, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)state.getClass().getName(), (OutputStream)outputStream);
            state.serialize(outputStream);
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    private CombineRequest translateFromTPipeTransferReq(TPipeTransferReq transferReq) throws Exception {
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        this.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)transferReq.body);
        this.regionId = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        this.combineId = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        String stateClassName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        this.state = (State)Class.forName(stateClassName).newInstance();
        this.state.deserialize(transferReq.body);
        this.version = transferReq.version;
        this.type = transferReq.type;
        return this;
    }

    public String toString() {
        return "CombineRequest{pipeName='" + this.pipeName + '\'' + ", creationTime=" + this.creationTime + ", regionId=" + this.regionId + ", combineId='" + this.combineId + '\'' + ", state=" + this.state + '}';
    }
}

