/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class TimestampRange
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -3597929310338724839L;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp from;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp to;

    public static @UnknownKeyFor @NonNull @Initialized TimestampRange of(@UnknownKeyFor @NonNull @Initialized Timestamp from, @UnknownKeyFor @NonNull @Initialized Timestamp to) {
        return new TimestampRange(from, to);
    }

    @VisibleForTesting
    TimestampRange(@UnknownKeyFor @NonNull @Initialized Timestamp from, @UnknownKeyFor @NonNull @Initialized Timestamp to) {
        Preconditions.checkArgument((from.compareTo(to) <= 0 ? 1 : 0) != 0, (String)"Malformed range [%s, %s)", (Object)from, (Object)to);
        this.from = from;
        this.to = to;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getFrom() {
        return this.from;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getTo() {
        return this.to;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "[" + this.from + ", " + this.to + ')';
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimestampRange)) {
            return false;
        }
        TimestampRange that = (TimestampRange)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

