/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinter;
import com.ibm.as400.access.NPCPSelPrtD;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class PrinterList
extends PrintObjectList<Printer>
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRINTER_FILTER = "printerFilter";

    public PrinterList() {
        super(3, new NPCPSelPrtD());
    }

    public PrinterList(AS400 system) {
        super(3, new NPCPSelPrtD(), system);
    }

    @Override
    void chooseImpl() {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use PrinterList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)system.loadImpl2("com.ibm.as400.access.PrinterListImplRemote", "com.ibm.as400.access.PrinterListImplProxy");
        super.setImpl();
    }

    public String getPrinterFilter() {
        NPCPSelPrtD selectionCP = (NPCPSelPrtD)this.getSelectionCP();
        return selectionCP.getPrinter();
    }

    @Override
    Printer newNPObject(NPCPID cpid, NPCPAttribute cpattr) {
        return new Printer(this.system_, (NPCPIDPrinter)cpid, cpattr);
    }

    public void setPrinterFilter(String printerFilter) throws PropertyVetoException {
        if (printerFilter == null) {
            Trace.log(2, "Parameter 'printerFilter' is null");
            throw new NullPointerException(PRINTER_FILTER);
        }
        if (printerFilter.length() > 10) {
            Trace.log(2, "Parameter 'printerFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("printerFilter(" + printerFilter + ")", 1);
        }
        String oldPrinterFilter = this.getPrinterFilter();
        this.vetos.fireVetoableChange(PRINTER_FILTER, oldPrinterFilter, printerFilter);
        NPCPSelPrtD selectionCP = (NPCPSelPrtD)this.getSelectionCP();
        selectionCP.setPrinter(printerFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("printer", printerFilter);
        }
        this.changes.firePropertyChange(PRINTER_FILTER, oldPrinterFilter, printerFilter);
    }
}

