/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaProperty;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.codehaus.groovy.reflection.AccessPermissionChecker;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedField
extends MetaProperty {
    private final Field field;
    private boolean madeAccessible;

    public CachedField(Field field) {
        super(field.getName(), field.getType());
        this.field = field;
    }

    private void makeAccessible() {
        ReflectionUtils.makeAccessibleInPrivilegedAction(this.field);
        AccessPermissionChecker.checkAccessPermission(this.field);
        this.madeAccessible = true;
    }

    public Field getCachedField() {
        if (!this.madeAccessible) {
            this.makeAccessible();
        }
        return this.field;
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public Object getProperty(Object object) {
        Field field = this.getCachedField();
        try {
            return field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e);
        }
    }

    @Override
    public void setProperty(Object object, Object newValue) {
        if (this.isFinal()) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "' because the backing field is final.");
        }
        newValue = DefaultTypeTransformation.castToType(newValue, this.field.getType());
        Field field = this.getCachedField();
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "'.", e);
        }
    }

    public MethodHandle asAccessMethod(MethodHandles.Lookup lookup) throws IllegalAccessException {
        try {
            return lookup.unreflectGetter(this.field);
        }
        catch (IllegalAccessException e) {
            if (!this.madeAccessible) {
                try {
                    this.makeAccessible();
                    return lookup.unreflectGetter(this.field);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
            }
            throw e;
        }
    }
}

